package org.gcube.applicationsupportlayer.social;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.UUID;

import org.apache.commons.io.IOUtils;
import org.apache.commons.net.ftp.FTP;
import org.apache.commons.net.ftp.FTPClient;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.FeedType;
import org.gcube.portal.databook.shared.ImageType;
import org.gcube.portal.databook.shared.PrivacyLevel;


/**
 * 
 * @author Massimiliano Assante, ISTI-CNR
 * @version 0.1 Dec 2012
 *
 * use to share updates from within your applicationProfile, the update will be published in the Users News Feed belonging to the VRE your applicationProfile runs into 
 */
public class ApplicationNewsManager extends SocialPortalBridge implements NewsManager  {
	
	static GCUBEClientLog _log = new GCUBEClientLog(ApplicationNewsManager.class);

	/**
	 * the FTP Server RuntimeResource coordinates
	 */
	private static String RUNTIME_RESOURCE_NAME = "SocialPortalStorage";
	private static String CATEGORY_NAME = "FTPServer";
	/**
	 * 
	 * @param aslSession the ASLSession instance
	 * @param portletClassName your portlet class name will be used ad unique identifier for your applicationProfile
	 */
	public ApplicationNewsManager(ASLSession session, String portletClassName) {
		super(session, portletClassName);
	}	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean shareApplicationUpdate(String feedText) {
		return getStoreInstance().saveAppFeed(buildFeed(feedText, "", "", "", ""));
	}
	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean shareApplicationUpdate(String feedText, String uriParams) {
		return getStoreInstance().saveAppFeed(buildFeed(feedText, uriParams, "", "", ""));
	}
	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean shareApplicationUpdate(String feedText, String uriParams, String previewTitle, String previewDescription, String previewThumbnailUrl) {
		return getStoreInstance().saveAppFeed(buildFeed(feedText, uriParams, previewTitle, previewDescription, previewThumbnailUrl));
	}
	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean shareApplicationUpdate(String feedText, String uriParams, String previewTitle, String previewDescription, InputStream previewThumbnailInputStream, ImageType imageExtension) {
		String httpImageUrl = uploadImageOnFTPServer(previewThumbnailInputStream, imageExtension);
		return shareApplicationUpdate(feedText, uriParams, previewTitle, previewDescription, httpImageUrl);
	}
	/**
	 * buid a an ApplicationProfile Feed
	 * 
	 * @param description add a description for the update you are sharing
	 * @param uriParams the additional parameteres your applicationProfile needs to open the subject of this update  e.g. id=12345&type=foo
	 * @param previewTitle the title to show in the preview
	 * @param previewDescription the description to show in the preview
	 * @param previewThumbnailUrl the image url to show in the preview
	 * @return a feed instance ready to be written
	 */
	private Feed buildFeed(String description, String uriParams, String previewTitle, String previewDescription, String previewThumbnailUrl) {
		String descToAdd = escapeHtml(description);

		String uri = applicationProfile.getUrl();
		//add the GET params if necessary
		if (uriParams != null && uriParams.compareTo("") != 0)
			uri += "?"+uriParams;		
		//String scope = getScopeByOrganizationId(""+aslSession.getGroupId());
		String scope = aslSession.getScopeName();
		System.out.println("scope: " + aslSession.getScopeName());
		Feed toReturn = new Feed( 
				UUID.randomUUID().toString(), 
				FeedType.PUBLISH, 
				applicationProfile.getKey(), 
				new Date(), 
				scope, 
				uri, 
				previewThumbnailUrl, 
				descToAdd, 
				PrivacyLevel.SINGLE_VRE, 
				applicationProfile.getName(), 
				"no-email", 
				applicationProfile.getImageUrl(), 
				previewTitle, 
				previewDescription, 
				"", 
				true);
		return toReturn;
	}	
	/**
	 * 
	 * @param previewThumbnailInputStream .
	 * @param imageExtension .
	 * @return the http url of the image uploaded on the ftp server
	 */
	private String uploadImageOnFTPServer(InputStream previewThumbnailInputStream, ImageType imageExtension) {
		FTPClient client = new FTPClient( );
		InputStream inputStream = previewThumbnailInputStream;
				
		String ftpUrl = "";
		String user = "";
		String pwd = "";
		String httpBaseURL = "";
		String fileName = UUID.randomUUID() + "." + imageExtension.toString().toLowerCase();
		try {	
			GCUBERuntimeResource res = getConfigurationFromIS();
			ftpUrl = res.getAccessPoints().get(0).getEndpoint();
			httpBaseURL = res.getHostedOn();
			user = res.getAccessPoints().get(0).getUsername();
			pwd = res.getAccessPoints().get(0).getPassword();
		
			// Connect to the FTP server as anonymous
		    client.connect(ftpUrl);
		    client.login(user, pwd);

		    client.setFileType(FTP.BINARY_FILE_TYPE);
		    client.enterLocalPassiveMode();
	    
		    BufferedInputStream bis = new BufferedInputStream(inputStream);		    
		    client.storeFile(fileName, bis);
		    bis.close();
	        client.logout();
		} catch(IOException ioe) {
			ioe.printStackTrace();
			_log.error( "Error communicating with FTP server." );
		} catch (Exception e) {
			_log.error( "Probably sth wrong in fetching FTP Server RuntimeResource from IS" );
			e.printStackTrace();
		} finally {
		    IOUtils.closeQuietly( inputStream );
		    try {
		        client.disconnect( );
		    } catch (IOException e) {
		    	_log.error( "Problem disconnecting from FTP server" );
		    }
		}
		StringBuilder sb = new StringBuilder().append(httpBaseURL).append("/").append(fileName);
        _log.info( "Uploaded file FTP server: http url: " + sb );
		return sb.toString();
	}	

	/**
	 * 
	 * @return the runtime resource of the FTP Server node
	 * @throws Exception
	 */
	private GCUBERuntimeResource getConfigurationFromIS() throws Exception  {
		ISClient client = GHNContext.getImplementation(ISClient.class);
		GHNContext ctx = GHNContext.getContext();
		String scope = "/" + (String) ctx.getProperty(GHNContext.INFRASTRUCTURE_NAME, true);
		GCUBERuntimeResourceQuery query = client.getQuery(GCUBERuntimeResourceQuery.class);
		query.addAtomicConditions(new AtomicCondition("/Profile/Name", RUNTIME_RESOURCE_NAME));
		query.addAtomicConditions(new AtomicCondition("/Profile/Category", CATEGORY_NAME));
		return client.execute(query, GCUBEScope.getScope(scope)).get(0);
	}	
}
