package org.gcube.application.framework.harvesting.common.db.is;


import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;

import static org.gcube.resources.discovery.icclient.ICFactory.*;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.gcube.application.framework.core.genericresources.model.ISGenericResource;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.core.util.GenericResource;
import org.gcube.application.framework.core.util.RuntimeResource;
import org.gcube.application.framework.harvesting.common.db.tools.DBConstants;
import org.gcube.application.framework.harvesting.common.db.tools.SourcePropsTools;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.DBProps;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.DBSource;
import org.gcube.common.database.DatabaseProvider;
import org.gcube.common.database.endpoint.DatabaseEndpoint;
import org.gcube.common.database.engine.DatabaseInstance;
import org.gcube.common.database.is.ISDatabaseProvider;
import org.gcube.common.resources.gcore.GCoreEndpoint.Profile.AccessPoint;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISResources {
	
	/** The logger. */
	private static final Logger logger = LoggerFactory.getLogger(ISResources.class);
	
	protected static ScopedPublisher scopedPublisher = null;
	protected static DiscoveryClient<ServiceEndpoint> client = null;
	
	
	private static DatabaseProvider isDBProvider = new ISDatabaseProvider();
	
	
//	public static void getConnectionString(String scope){
//		ScopeProvider.instance.set(scope);
//		
//		DatabaseEndpoint endpoint = isDBProvider.get("TabularData Database", "Data-Admin");
// 
//		DatabaseInstance db = isDBProvider.get("Fishbase");
//		
//		db.getEndpoints().get
// 
//		String connectionString = isDBProvider.get("TabularData Database", "Data-Admin").getConnectionString();
//	}
	
	

	public static DBSource getDBSourceInfo(String dbName, String scope) throws MalformedURLException{
		ScopeProvider.instance.set(scope);
		logger.debug("Searching for dbName: "+dbName+ " on scope: "+scope);
		DatabaseInstance db = isDBProvider.get(dbName);
		DatabaseEndpoint [] endpoints = db.getEndpoints().values().toArray(new DatabaseEndpoint[0]);
		logger.debug("Endpoints.length: "+endpoints.length);
		for(DatabaseEndpoint ep : endpoints){
			logger.debug("ep.getId(): "+ep.getId());
			logger.debug("ep.getConnectionString(): "+ep.getConnectionString());
			logger.debug("ep.getDescription(): "+ep.getDescription());
			logger.debug("username: "+ep.getCredentials().getUsername());
			logger.debug("password: "+ep.getCredentials().getPassword());
			logger.debug("num of properties: "+ep.getProperties().size());
		}
			
		return new DBSource();
		
//		DBSource output = new DBSource();
//		output.setDBName(db.getName());
//		output.setDBType(db.ge);
//		output.setConnectionString(db.get);
//		output.setHostName(db.getHostingURL());
//		output.setUserName(db.get);
//		output.setPassword(password);
//		output.setSourceName(sourcename);
//		output.setVersionMajor(versionMajor);
//		output.setVersionMinor(versionMinor);
		
		
		
		
		
		
//		SimpleQuery query = queryFor(ServiceEndpoint.class);
//		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
//		query.addCondition("$resource/Profile/Category eq '"+DBConstants.RUNNING_CATEGORY_NAME+"'");
//		ArrayList <DBSource> lst = new ArrayList<DBSource>();
//		List<ServiceEndpoint> resources = client.submit(query);
////		DatabaseProvider isDBProvider = new ISDatabaseProvider();
//		for(ServiceEndpoint se : resources){
//			System.out.println("Getting props of : "+se.profile().name());
////			DatabaseInstance db = isDBProvider.get(se.profile().name());
//			/*
//			DatabaseEndpoint endpoint = isDBProvider.get(se.profile().name(),CATEGORY_NAME);
//			System.out.println("endpoint.getId(): "+endpoint.getId());
//			System.out.println("username: "+endpoint.getCredentials().getUsername());
//			System.out.println("password: "+endpoint.getCredentials().getPassword());
//			System.out.println("endpoint.getConnectionString(): "+endpoint.getConnectionString());
//			System.out.println("endpoint.getDescription(): "+endpoint.getDescription());
//			for(DatabaseProperty prop : endpoint.getProperties())
//				System.out.println(prop.getKey()+": "+prop.getValue());
//			*/
//			AccessPoint [] ap = se.profile().accessPoints().toArray(new AccessPoint[0]);
//			DBSource dbInfo = new DBSource();
//			dbInfo.setSourceName(se.profile().name());
//			dbInfo.setDBName(se.profile().accessPoints().toArray(new AccessPoint[0])  ));
//			dbInfo.setDBType(se.profile().platform().name());
//			dbInfo.setHostName(se.profile().runtime().hostedOn());
////			dbInfo.setUserName(se.profile().accessPoints().toArray(new AccessPoint[0])[0].username());
////			dbInfo.setPassword(se.profile().accessPoints().toArray(new AccessPoint[0])[0].password());
//			dbInfo.setVersionMajor(se.profile().platform().version());
//			dbInfo.setVersionMinor(se.profile().platform().minorVersion());
//			lst.add(dbInfo);
//		}
//		System.out.println("Found "+lst.size()+" sources of type "+ DBConstants.RUNNING_CATEGORY_NAME);
//		return lst.toArray(new DBSource[0]);
	}

	
//	public static String getDBPropsByName(String scope, String dbName, String propsName) throws Exception{
//		ScopeProvider.instance.set(scope);
//		List<ISGenericResource> output = new ArrayList<ISGenericResource>();
//		SimpleQuery queryMan = null;
//		try {
//			queryMan = queryFor(org.gcube.common.resources.gcore.GenericResource.class);
//			queryMan.addCondition("$resource/Profile/SecondaryType eq '"+type+"'");
////			List <org.gcube.common.resources.gcore.GenericResource> results = 
//					client.submit(queryMan);
//			for(org.gcube.common.resources.gcore.GenericResource res : results)
//				output.add(new ISGenericResource(res.id(),res.profile().name(),res.profile().description(),res.profile().bodyAsString(),res.profile().type()));
//			return output;
//		} catch (Exception e) {
//			logger.error("Exception:", e);
//			throw new RemoteException();
//		}
//		
//		
//		
//		String result = new String();
//		for(ISGenericResource res : allRes){
//			DBProps props = SourcePropsTools.parseSourceProps(res.getBody());
//			if(res.getName().equals(propsName) && props.getSourceName().equals(dbName)){
//				System.out.println("propsName: "+res.getName()+"\tdbName: "+props.getSourceName());
//				result = res.getBody();
//			}
//		}
//		return result;
//	}

	

}


