package org.gcube.application.framework.contentmanagement.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

import org.gcube.application.framework.contentmanagement.model.CollectionInfo;
import org.gcube.application.framework.core.util.SearchField;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEMCollectionQuery;
import org.gcube.common.core.resources.GCUBEMCollection;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.informationsystem.client.eximpl.ExistQuery;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.ViewReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.views.MetadataView;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeMetadata;
import org.gcube.contentmanagement.gcubemodellibrary.elements.MetadataElements;

import static org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections.*;


/**
 * @author Valia Tsagkalidou (KNUA)
 * @author Rena Tsantouli
 */
public class FindInfo {

	public static final String ALL = "ALL";
	public static final String NAME = "NAME";
	public static final String DESCRIPTION = "DESCRIPTION";
	
	/**
	 * @param colID
	 * @param collections
	 * @return
	 */
	public static CollectionInfo findCollectionInfo(String colID, List<CollectionInfo>[] collections)
	{
		if (collections != null) {
			for(int counter=0; counter < collections.length;counter++)
			{
				for(int c2=0; c2 < collections[counter].size(); c2++)
				{
					System.out.println("compare: " + collections[counter].get(c2).getId() + " with: " + colID);
					if(collections[counter].get(c2).getId().equals(colID))
					{
						System.out.println("equal!!");
						return collections[counter].get(c2);
					}
				}
			}
		}
		else {
			System.out.println("No collections!!");
			return null;
		}
		System.out.println("Null!!");
		return null;
	}
	
	/**
	 * @param metadataColID
	 * @param collections
	 * @return
	 */
	public static CollectionInfo findCollectionInfoFromMetadata(String metadataColID, List<CollectionInfo>[] collections)
	{
		for(int counter=0; counter < collections.length;counter++)
		{
			for(int c2=1; c2 < collections[counter].size(); c2++)
			{
				for(int c3=0; c3 < collections[counter].get(c2).getMetadataSize(); c3++)
				{
					if(collections[counter].get(c2).getMetadataID(c3).equals(metadataColID))
					{
						return collections[counter].get(c2);
					}
				}
			}
		}
		return null;
	}
	
	
	/**
	 * @param MCISID metadata collection id
	 * @param scope gcube scope
	 * @return String oid
	 */
	// TO BE REMOVED WITH NEW CMS
	public static String getMCOIDFromISID(String MCISID, GCUBEScope scope) throws Exception {
	  /*  String queryExpr = ExistQuery.NS + "for $result in collection(\"/db/Profiles/MetadataCollection\")//Document/Data/is:Profile/Resource where ($result/Resource/ID/text() eq '" + MCISID + "' return $result/OID/text()";
	
	    ISClient client = GHNContext.getImplementation(ISClient.class);
	    GCUBEGenericQuery query = client.getQuery(GCUBEGenericQuery.class);
	    query.setExpression(queryExpr);
	    List<XMLResult> result = client.execute(query, scope);
	    return result.get(0).evaluate("/Resource/Profile/OID/text()").get(0); */
		
		ISClient client = GHNContext.getImplementation(ISClient.class);
		GCUBEMCollectionQuery mcolQuery = client.getQuery(GCUBEMCollectionQuery.class);
		AtomicCondition mcIDAtomicCondition = new AtomicCondition("/ID", MCISID);
		mcolQuery.addAtomicConditions(mcIDAtomicCondition);
		System.out.println("The query expression is: << "+ mcolQuery.getExpression() + " >>");
		List<GCUBEMCollection> results = client.execute(mcolQuery,scope);
		if (results != null && results.size() > 0)
			return results.get(0).getOID();
		else
			return null;
	}
	
	
	public static String getRandomMetadataContentOfView(String metadataViewID, String scope) {
		System.out.println("Getting random metadata of view: " + metadataViewID);
		MetadataView mView = new MetadataView(GCUBEScope.getScope(scope));
		mView.setId(metadataViewID);
		List<MetadataView> similars = null;
		try {
			similars = mView.findSimilar();
		} catch (ISException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		if (similars != null && !similars.isEmpty()) {
			System.out.println("Got similars");
			MetadataView mv = similars.get(0);
			try {
				ViewReader vReader = mv.reader();
				
				// TODO: A projection might be needed for specifying the schema URI!
				RemoteIterator<GCubeDocument> metaPayloads = vReader.get(metadata().with(BYTESTREAM));
				if (metaPayloads.hasNext()) {
					//byte[] bArray = metaPayloads.next().bytestream();
					MetadataElements meta = metaPayloads.next().metadata();
					Iterator<GCubeMetadata> iter = meta.iterator();
					while (iter.hasNext()) {
						System.out.println("Found metadata!");
						return new String(iter.next().bytestream());
					}
					//return new String(bArray);
				}
				else 
					System.out.println("Meta Payloads is EMPTY");
			} catch (IllegalStateException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		else 
			System.out.println("The similars is NULL! - not View Find");
		return null;
	}
	

	
	/**
	 * @param term
	 * @param whereToSearch
	 * @param collections
	 * @return
	 */
	public static List<CollectionInfo> searchCollectionInfo(String term, String whereToSearch, List<CollectionInfo>[] collections)
	{
		term = term.trim().toLowerCase();
		if(term.startsWith("*"))
		{
			term = term.substring(1);
		}
		else
		{
			term = "(\\s|\\p{Punct})" + term;
		}
		if(term.endsWith("*"))
		{
			term = term.substring(0,term.length()-1);
		}
		else
		{
			term = term + "(\\s|\\p{Punct})";
		}
		term = term.replaceAll("\\x2A", ".*");
		term = term.replaceAll("\\x3F", ".");
	    Pattern pattern = Pattern.compile(term);
	    
		boolean name = false, descr = false;
		if(whereToSearch.equals(FindInfo.ALL))
		{
			name = true;
			descr = true;
		}
		else if(whereToSearch.equals(FindInfo.NAME))
		{
			name = true;
		}
		else if(whereToSearch.equals(FindInfo.DESCRIPTION))
		{
			descr = true;
		}
		List<CollectionInfo> res = new ArrayList<CollectionInfo>();
		for(int counter=0; counter < collections.length;counter++)
		{
			for(int c2=0; c2 < collections[counter].size(); c2++)
			{
				if(name)
				{
					if(pattern.matcher(" " + collections[counter].get(c2).getName().toLowerCase() + " ").find())
					{
						res.add(collections[counter].get(c2));
						continue;
					}
				}
				if(descr)
				{
					if(pattern.matcher(" " + collections[counter].get(c2).getDescription().toLowerCase() + " ").find())
					{
						res.add(collections[counter].get(c2));
						continue;
					}
				}
			}
		}
		return res;
	}
	
	/**
	 * @param schemaName
	 * @param collection
	 * @return
	 */
	public static int findCollectionSchema(String schemaName, CollectionInfo collection)
	{
		for(int counter =0; counter < collection.getMetadataSize(); counter++)
		{
			if(collection.getSchema(counter).equals(schemaName))
			{
				return counter;
			}
		}
		return -1;
	}
	
	public static int findCollectionSchema(String schemaName, String schemaLanguage, CollectionInfo collection) {
		for (int counter = 0; counter < collection.getMetadataSize(); counter++) {
			if (collection.getSchema(counter).equals(schemaName)) 
			{
				if (collection.getLanguage(counter).equals(schemaLanguage))
					return counter;
			}
		}
		return -1;
	}
	
	/**
	 * @param name
	 * @param schemaName
	 * @param SchemaHashMap
	 * @return
	 */
	public static int findCriterion(String name, String schemaName, HashMap<String, List<SearchField>> SchemaHashMap)
	{
		List<SearchField> schemaCriteria = SchemaHashMap.get(schemaName);
		for(int counter = 0; counter < schemaCriteria.size(); counter++)
		{// finding details regarding this criterion
			if(schemaCriteria.get(counter).name.equals(name))
			{
				return counter;
			}
		}
		return -1;
	}
	

	/**
	 * @param collections the available collections in a hierarchical structure
	 * @return a HashMap: contains pairs of <content/metadata collection ID, collection name>
	 */
	public static HashMap<String, String> getCollectionNames(List<CollectionInfo>[] collections)
	{		
		HashMap<String, String> collectionMap = new HashMap();
		collectionMap = new HashMap<String, String>();
		if(collections == null)
			return collectionMap;
		for(int i=0; i< collections.length; i++)
		{
			for(int k=0; k < collections[i].size(); k++)
			{
				for(int j=0; j< collections[i].get(k).getMetadataSize(); j++)
				{
					collectionMap.put(collections[i].get(k).getMetadataID(j), collections[i].get(k).getName());
				}
				collectionMap.put(collections[i].get(k).getId(), collections[i].get(k).getName());
			}
		}
		return collectionMap;
	}
	
	
}
