package org.gcube.application.framework.contentmanagement.content.impl;

import java.io.InputStream;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;

import org.gcube.application.framework.contentmanagement.exceptions.ContentReaderCreationException;
import org.gcube.application.framework.contentmanagement.exceptions.DocumentRetrievalException;
import org.gcube.application.framework.contentmanagement.util.DocumentInfos;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.informationsystem.client.*;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.contentmanagement.gcubedocumentlibrary.util.Collections;
import org.gcube.contentmanagement.contentmanager.smsplugin.util.GCubeCollections;
import org.gcube.contentmanagement.contentmanager.stubs.CollectionReference;
import org.gcube.contentmanagement.contentmanager.stubs.calls.ManagerCall.DiscoveryException;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import static org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections.*;


public class Collection {
	
	static ISClient client;
	
	/**
	 * the D4Science session
	 */
	protected ASLSession session;
	protected String colID;
	
	protected static AtomicInteger cmsId = new AtomicInteger(0);
	protected static AtomicInteger colMSId = new AtomicInteger(0);

	
	public Collection (ASLSession ses, String collectionId) {
		session = ses;
		colID = collectionId;
	}
	
	
	
	/**
	 * This method retrieves the ID of a collection with a specific name
	 * 
	 * @param name: the name of the collection
	 * @param colms: the port type of the collection management service
	 * @return: the collection's ID
	 * @throws GCUBEFault an error occurred
	 */
	public static String getCollectionByName(String name, ASLSession ses) {	
		try {
			List<org.gcube.contentmanagement.gcubedocumentlibrary.util.Collection> collections = Collections.findByName(ses.getScope(), name);
			if (collections != null && collections.size() > 0) {
				if (collections.size() > 1)
					System.out.println("More than one collections detected with the same name. The first one will be used");
				System.out.println("Returning the ID of the collection with name --> " + name + ". The ID is --> " + collections.get(0).getId());
				return collections.get(0).getId();
			}
		} catch (Exception e) {
			System.out.println("An exception was thrown while trying to find the collection with name: " + name);
			return null;
		}
		return null;

	}
	
	
	public static String createCollection (String collectionName, ASLSession ses, Boolean userCollection)  {
		String colId = null;
		// we do want to propagage the request to others CM
		boolean propagateRequest = true;
		
		// we want the collection to be readable and writable
		boolean readable = true;
		boolean writable = true;
		
		// finally we create the collection. A non-user collection
		List<CollectionReference> collectionReferences = null;
		
		try{
			collectionReferences = GCubeCollections.createGCubeCollection(propagateRequest, collectionName, "", false, readable, writable, ses.getScope());
		} catch (Exception e) {
			System.out.println("An exception was thrown while trying to create a collection.");
			e.printStackTrace();
		}
		
		if (collectionReferences != null) {
			System.out.println("Collection with name: " + collectionName + " has just been created. Only one reference should have been returned.");
			if (collectionReferences.size() > 1) 
				System.out.println("More than one references have been returned. The first one will be used");
			colId = collectionReferences.get(0).getCollectionID();
			System.out.println("The ID of the created collection is: " + colId);
		}
		return colId;
	}
	
	
	
	public static boolean deleteCollection (String collectionID, ASLSession ses) {
		try {
			GCubeCollections.deleteGCubeCollection(collectionID, true, ses.getScope());
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return true;
	}
	
	
	public DigitalObject addMember (InputStream content, String fileName, String mimeType) {
		DigitalObject newDO = org.gcube.application.framework.contentmanagement.content.impl.DigitalObject.createNewDigitalObject(colID, content, fileName, session, mimeType);
		return newDO;
	}

	
	public void removeMember (String oid, String collectionId, ASLSession ses) {
		DocumentWriter writer = null;
		try {
			writer = new DocumentWriter(collectionId, session.getScope());
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		GCubeDocument document = new GCubeDocument(oid);

		try {
			writer.delete(document);
		} catch (DiscoveryException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (GCUBEException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	
	public String[] getMemberIDs (String collectionId, ASLSession ses) {
		DocumentReader reader = null;
		try {
			reader = new DocumentReader(colID, session.getScope());
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		String[] ids = null;
		ArrayList<String> idsList = new ArrayList<String>();
		try {
			RemoteIterator<GCubeDocument> docs = reader.get(document().with(CREATION_TIME));
			while (docs.hasNext()) {
				idsList.add(docs.next().id());
			}
			
			ids = new String[idsList.size()];
			for (int i = 0; i < idsList.size(); i++) {
				ids[i] = idsList.get(i);
			}
			
		} catch (DiscoveryException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (GCUBEException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return ids;
	}
	
	public ArrayList<DocumentInfos> getDocumentInfos(ASLSession session) throws ContentReaderCreationException, DocumentRetrievalException {
		DocumentReader reader = null;
		try {
			reader = new DocumentReader(colID, session.getScope());
		} catch (Exception e) {
			throw new ContentReaderCreationException(e);
		}
		
		ArrayList<DocumentInfos> documentInfos = new ArrayList<DocumentInfos>();
		try {
			RemoteIterator<GCubeDocument> docs = reader.get(document().allexcept(BYTESTREAM));
			while (docs.hasNext()) {
				DocumentInfos docInfo = new DocumentInfos();
				GCubeDocument doc = docs.next();
				docInfo.setDocumentId(doc.id());
				docInfo.setName(doc.name());
				documentInfos.add(docInfo);
			}
			
			
		} catch (DiscoveryException e) {
			throw new DocumentRetrievalException(e);
		} catch (GCUBEException e) {
			throw new DocumentRetrievalException(e);
		} catch (Exception e) {
			throw new DocumentRetrievalException(e);
		}
		return documentInfos;
	}

}
