/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.gcube.application.framework.contentmanagement.model.CollectionInfo;
import org.gcube.application.framework.core.util.SearchField;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEMCollectionQuery;
import org.gcube.common.core.resources.GCUBEMCollection;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.ViewReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.gcubedocumentlibrary.views.MetadataView;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeMetadata;
import org.gcube.contentmanagement.gcubemodellibrary.elements.MetadataElements;

public class FindInfo {
    public static final String ALL = "ALL";
    public static final String NAME = "NAME";
    public static final String DESCRIPTION = "DESCRIPTION";

    public static CollectionInfo findCollectionInfo(String colID, List<CollectionInfo>[] collections) {
        if (collections != null) {
            for (int counter = 0; counter < collections.length; ++counter) {
                for (int c2 = 0; c2 < collections[counter].size(); ++c2) {
                    System.out.println("compare: " + collections[counter].get(c2).getId() + " with: " + colID);
                    if (!collections[counter].get(c2).getId().equals(colID)) continue;
                    System.out.println("equal!!");
                    return collections[counter].get(c2);
                }
            }
        } else {
            System.out.println("No collections!!");
            return null;
        }
        System.out.println("Null!!");
        return null;
    }

    public static CollectionInfo findCollectionInfoFromMetadata(String metadataColID, List<CollectionInfo>[] collections) {
        for (int counter = 0; counter < collections.length; ++counter) {
            for (int c2 = 1; c2 < collections[counter].size(); ++c2) {
                for (int c3 = 0; c3 < collections[counter].get(c2).getMetadataSize(); ++c3) {
                    if (!collections[counter].get(c2).getMetadataID(c3).equals(metadataColID)) continue;
                    return collections[counter].get(c2);
                }
            }
        }
        return null;
    }

    public static String getMCOIDFromISID(String MCISID, GCUBEScope scope) throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEMCollectionQuery mcolQuery = (GCUBEMCollectionQuery)client.getQuery(GCUBEMCollectionQuery.class);
        AtomicCondition mcIDAtomicCondition = new AtomicCondition("/ID", MCISID);
        mcolQuery.addAtomicConditions(new AtomicCondition[]{mcIDAtomicCondition});
        System.out.println("The query expression is: << " + mcolQuery.getExpression() + " >>");
        List results = client.execute((ISQuery)mcolQuery, scope);
        if (results != null && results.size() > 0) {
            return ((GCUBEMCollection)results.get(0)).getOID();
        }
        return null;
    }

    public static String getRandomMetadataContentOfView(String metadataViewID, String scope) {
        block10: {
            System.out.println("Getting random metadata of view: " + metadataViewID);
            MetadataView mView = new MetadataView(GCUBEScope.getScope((String)scope));
            mView.setId(metadataViewID);
            List similars = null;
            try {
                similars = mView.findSimilar();
            }
            catch (ISException e1) {
                e1.printStackTrace();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (similars != null && !similars.isEmpty()) {
                System.out.println("Got similars");
                MetadataView mv = (MetadataView)similars.get(0);
                try {
                    ViewReader vReader = mv.reader();
                    RemoteIterator metaPayloads = vReader.get((Projection)Projections.metadata().with((Property)Projections.BYTESTREAM, (Property[])new PropertyTypes.MetadataProperty[0]));
                    if (metaPayloads.hasNext()) {
                        MetadataElements meta = ((GCubeDocument)metaPayloads.next()).metadata();
                        Iterator iter = meta.iterator();
                        if (iter.hasNext()) {
                            System.out.println("Found metadata!");
                            return new String(((GCubeMetadata)iter.next()).bytestream());
                        }
                        break block10;
                    }
                    System.out.println("Meta Payloads is EMPTY");
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("The similars is NULL! - not View Find");
            }
        }
        return null;
    }

    public static List<CollectionInfo> searchCollectionInfo(String term, String whereToSearch, List<CollectionInfo>[] collections) {
        term = (term = term.trim().toLowerCase()).startsWith("*") ? term.substring(1) : "(\\s|\\p{Punct})" + term;
        term = term.endsWith("*") ? term.substring(0, term.length() - 1) : term + "(\\s|\\p{Punct})";
        term = term.replaceAll("\\x2A", ".*");
        term = term.replaceAll("\\x3F", ".");
        Pattern pattern = Pattern.compile(term);
        boolean name = false;
        boolean descr = false;
        if (whereToSearch.equals(ALL)) {
            name = true;
            descr = true;
        } else if (whereToSearch.equals(NAME)) {
            name = true;
        } else if (whereToSearch.equals(DESCRIPTION)) {
            descr = true;
        }
        ArrayList<CollectionInfo> res = new ArrayList<CollectionInfo>();
        for (int counter = 0; counter < collections.length; ++counter) {
            for (int c2 = 0; c2 < collections[counter].size(); ++c2) {
                if (name && pattern.matcher(" " + collections[counter].get(c2).getName().toLowerCase() + " ").find()) {
                    res.add(collections[counter].get(c2));
                    continue;
                }
                if (!descr || !pattern.matcher(" " + collections[counter].get(c2).getDescription().toLowerCase() + " ").find()) continue;
                res.add(collections[counter].get(c2));
            }
        }
        return res;
    }

    public static int findCollectionSchema(String schemaName, CollectionInfo collection) {
        for (int counter = 0; counter < collection.getMetadataSize(); ++counter) {
            if (!collection.getSchema(counter).equals(schemaName)) continue;
            return counter;
        }
        return -1;
    }

    public static int findCollectionSchema(String schemaName, String schemaLanguage, CollectionInfo collection) {
        for (int counter = 0; counter < collection.getMetadataSize(); ++counter) {
            if (!collection.getSchema(counter).equals(schemaName) || !collection.getLanguage(counter).equals(schemaLanguage)) continue;
            return counter;
        }
        return -1;
    }

    public static int findCriterion(String name, String schemaName, HashMap<String, List<SearchField>> SchemaHashMap) {
        List<SearchField> schemaCriteria = SchemaHashMap.get(schemaName);
        for (int counter = 0; counter < schemaCriteria.size(); ++counter) {
            if (!schemaCriteria.get((int)counter).name.equals(name)) continue;
            return counter;
        }
        return -1;
    }

    public static HashMap<String, String> getCollectionNames(List<CollectionInfo>[] collections) {
        HashMap<String, String> collectionMap = new HashMap<String, String>();
        collectionMap = new HashMap();
        if (collections == null) {
            return collectionMap;
        }
        for (int i = 0; i < collections.length; ++i) {
            for (int k = 0; k < collections[i].size(); ++k) {
                for (int j = 0; j < collections[i].get(k).getMetadataSize(); ++j) {
                    collectionMap.put(collections[i].get(k).getMetadataID(j), collections[i].get(k).getName());
                }
                collectionMap.put(collections[i].get(k).getId(), collections[i].get(k).getName());
            }
        }
        return collectionMap;
    }
}

