/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanager.stubs.model;

import java.lang.reflect.Field;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Leaf;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.data.Tree;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class Taxon {
    @XmlAttribute(required=true)
    private String id;
    @XmlAttribute
    private String rank;
    @XmlAttribute
    private String scientificName;
    @XmlAttribute
    private String citation;
    @XmlElement
    protected Taxon parent = null;

    protected Taxon() {
    }

    public Taxon(String id) {
        this.id = id;
    }

    public Taxon(String id, String scientificName) {
        this.id = id;
        this.scientificName = scientificName;
    }

    public void setRank(String rank) {
        this.rank = rank;
    }

    public String getScientificName() {
        return this.scientificName;
    }

    public void setScientificName(String scientificName) {
        this.scientificName = scientificName;
    }

    public String getCitation() {
        return this.citation;
    }

    public void setCitation(String citation) {
        this.citation = citation;
    }

    public String getId() {
        return this.id;
    }

    public String getRank() {
        return this.rank;
    }

    public Taxon getParent() {
        return this.parent;
    }

    public void setParent(Taxon parent) {
        this.parent = parent;
    }

    protected Tree node() {
        Tree node = Nodes.t((String)this.id, (Edge[])new Edge[0]);
        if (this.parent != null) {
            node.add(Nodes.e((String)"parent", (Node)this.parent.node()));
        }
        node.add(Nodes.e((String)"citation", (Object)this.getCitation()));
        node.add(Nodes.e((String)"scientificName", (Object)this.getScientificName()));
        node.add(Nodes.e((String)"rank", (Object)this.getRank()));
        return node;
    }

    protected static Taxon fromNode(InnerNode node) throws Exception {
        Taxon taxon = new Taxon(node.id());
        Field[] fieldArray = Taxon.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (node.hasEdge(field.getName()) && node.edge(field.getName()).target() instanceof Leaf) {
                field.setAccessible(true);
                field.set(taxon, ((Leaf)node.edge(field.getName()).target()).value());
            }
            ++n2;
        }
        if (node.hasEdge("parent")) {
            taxon.parent = Taxon.fromNode((InnerNode)node.child("parent"));
        }
        return taxon;
    }

    public String toString() {
        StringBuilder toReturn = new StringBuilder();
        toReturn.append("[id: " + this.id + "]");
        toReturn.append("[scientificName :" + this.scientificName + "]");
        toReturn.append("[citation: " + this.citation + "]");
        toReturn.append("[rank: " + this.rank + "]");
        if (this.parent != null) {
            toReturn.append("[parent taxon: " + this.parent + "]");
        }
        return toReturn.toString();
    }
}

