package org.gcube.application.speciesmanager.stubs.pluginhelper.capabilities;

import java.util.List;

import org.gcube.application.speciesmanager.stubs.model.Taxon;
import org.gcube.application.speciesmanager.stubs.pluginhelper.PropertySupport;
import org.gcube.application.speciesmanager.stubs.pluginhelper.writers.ObjectWriter;


public interface ClassificationCapability extends PropertySupport{

	/**
	 * retrieves all children giving a taxon id
	 * 
	 * @param taxonId the taxon id
	 * @return a list of taxon
	 */
	public List<Taxon> retrieveTaxonChildsByTaxonId(String taxonId);
	
	/**
	 * retrieves a list of Taxon tree for a given name
	 * 
	 * @param writer the stream where the elements must be wrote
	 * @param name the name of the entity to retrieve  
	 */
	public void retrieveTaxaByName(ObjectWriter<Taxon> writer, String name);
	
	
	
}
