package org.gcube.application.speciesmanager.stubs.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.NONE)
public class CommonName {

	@XmlAttribute
	private String language;
	@XmlAttribute
	private String name;
	
	protected CommonName(){}
	
	public CommonName(String language, String name) {
		super();
		this.language = language;
		this.name = name;
	}



	public String getLanguage() {
		return language;
	}

	public String getName() {
		return name;
	}

	public String toString(){
		StringBuilder toReturn = new StringBuilder();
		toReturn.append("[ language: "+this.language+"]");
		toReturn.append("[ name: "+this.name+"]");
		return toReturn.toString();
	}
	
}
