/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanager.plugin;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.gcube.application.speciesmanager.context.ServiceContext;
import org.gcube.application.speciesmanager.stubs.pluginhelper.AbstractPlugin;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;

public class PluginManager {
    private static GCUBELog log = new GCUBELog(PluginManager.class);
    private ServiceLoader<AbstractPlugin> loader;
    private Map<String, AbstractPlugin> plugins = new HashMap<String, AbstractPlugin>();
    private GCUBEScope scope;
    private static Map<String, PluginManager> pluginManagersCache = new HashMap<String, PluginManager>();

    public static void remove(GCUBEScope scope) {
        if (pluginManagersCache.containsKey(scope.toString())) {
            pluginManagersCache.remove(scope.toString());
        }
    }

    public static PluginManager get(GCUBEScope scope) {
        if (pluginManagersCache.containsKey(scope.toString())) {
            return pluginManagersCache.get(scope.toString());
        }
        PluginManager pm = new PluginManager(scope);
        pluginManagersCache.put(scope.toString(), pm);
        return pm;
    }

    private PluginManager(GCUBEScope scope) {
        log.debug((Object)"entering in the PluginManager");
        this.scope = scope;
        this.initializePlugins();
    }

    public void add(GCUBERuntimeResource resource) {
        this.retrievePlugins(Collections.singletonMap(resource.getName(), resource));
    }

    public void update(GCUBERuntimeResource resource) {
        try {
            if (!resource.getScopes().containsKey(this.scope.toString())) {
                this.removePlugin(resource.getName());
            } else if (!this.plugins.containsKey(resource.getName())) {
                this.add(resource);
            } else {
                this.plugins.get(resource.getName()).initialize(resource);
            }
        }
        catch (Exception e) {
            log.error((Object)("error updateting plugin " + resource.getName()), (Throwable)e);
        }
    }

    public Map<String, AbstractPlugin> plugins() {
        return new HashMap<String, AbstractPlugin>(this.plugins);
    }

    public GCUBEScope getScope() {
        return this.scope;
    }

    private void retrievePlugins(Map<String, GCUBERuntimeResource> runtimeResourcePerPlugin) {
        for (AbstractPlugin plugin : this.loader) {
            GCUBERuntimeResource resource = null;
            resource = runtimeResourcePerPlugin.get(plugin.getRepositoryName());
            if (resource == null) continue;
            log.debug((Object)("found a repo plugin for " + plugin.getRepositoryName()));
            if (plugin.getRepositoryName() == null) {
                log.error((Object)("plugin " + plugin.getClass().getSimpleName() + " has a null repository name"));
                continue;
            }
            if (plugin.getRepositoryName().contains(":")) {
                log.error((Object)("plugin " + plugin.getClass().getSimpleName() + " contains an invalid character"));
                continue;
            }
            if (plugin.getDescription() == null) {
                log.warn((Object)("plugin " + plugin.getClass().getSimpleName() + " has a null description"));
                continue;
            }
            try {
                if (!plugin.isInitialized()) {
                    plugin.initialize(resource);
                    log.debug((Object)("initialization finished for plugin " + plugin.getRepositoryName()));
                }
                this.plugins.put(plugin.getRepositoryName(), plugin);
            }
            catch (Exception e) {
                log.error((Object)("initialization failed for plugin " + plugin.getRepositoryName()), (Throwable)e);
            }
        }
    }

    private void initializePlugins() {
        if (this.loader == null) {
            this.loader = ServiceLoader.load(AbstractPlugin.class);
        }
        HashMap<String, GCUBERuntimeResource> runtimeResourcePerPlugin = new HashMap<String, GCUBERuntimeResource>();
        try {
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBERuntimeResourceQuery query = (GCUBERuntimeResourceQuery)client.getQuery(GCUBERuntimeResourceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Category", ServiceContext.getContext().getRuntimeResourceCategory())});
            for (GCUBERuntimeResource resource : client.execute((ISQuery)query, this.scope)) {
                runtimeResourcePerPlugin.put(resource.getName(), resource);
            }
        }
        catch (Exception e) {
            log.warn((Object)"error discoverying runtime resources", (Throwable)e);
        }
        this.retrievePlugins(runtimeResourcePerPlugin);
    }

    public void removePlugin(String pluginName) {
        this.plugins.remove(pluginName);
    }

    public void remove() {
        this.initializePlugins();
    }
}

