/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanager.manager;

import java.util.ArrayList;
import org.gcube.application.speciesmanager.plugin.PluginManager;
import org.gcube.application.speciesmanager.stubs.CapabilityDescription;
import org.gcube.application.speciesmanager.stubs.PluginDescription;
import org.gcube.application.speciesmanager.stubs.PluginMap;
import org.gcube.application.speciesmanager.stubs.pluginhelper.AbstractPlugin;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Capabilities;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Properties;
import org.gcube.application.speciesmanager.stubs.pluginhelper.PropertySupport;
import org.gcube.application.speciesmanager.stubs.pluginhelper.SearchTypes;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceProperty;

public class Manager
extends GCUBEWSResource {
    private static String[] RPNames = new String[]{"Plugin"};

    public String[] getPropertyNames() {
        return RPNames;
    }

    protected void initialise(Object ... args) throws Exception {
        this.logger.info((Object)"creating manager resource");
    }

    public void publish(GCUBEScope ... scopes) throws ResourceException {
        GCUBEScope[] gCUBEScopeArray = scopes;
        int n = scopes.length;
        int n2 = 0;
        while (n2 < n) {
            GCUBEScope scope = gCUBEScopeArray[n2];
            this.addPluginsDescription(scope);
            ++n2;
        }
        super.publish(scopes);
    }

    public void unpublish(GCUBEScope ... scopes) throws ResourceException {
        GCUBEScope[] gCUBEScopeArray = scopes;
        int n = scopes.length;
        int n2 = 0;
        while (n2 < n) {
            GCUBEScope scope = gCUBEScopeArray[n2];
            this.removePluginsDescription(scope);
            PluginManager.remove(scope);
            ++n2;
        }
        super.unpublish(scopes);
    }

    public void removePluginsDescription(GCUBEScope scope) {
        ResourceProperty typeRP = this.getResourcePropertySet().get("Plugin");
        if (typeRP.size() == 0) {
            return;
        }
        PluginMap pm = null;
        int i = 0;
        while (i < typeRP.size()) {
            pm = (PluginMap)typeRP.get(i);
            if (pm.getKey().equals(scope.toString())) break;
            ++i;
        }
        if (pm != null) {
            typeRP.remove(pm);
        }
    }

    public void addPluginsDescription(GCUBEScope scope) {
        ResourceProperty typeRP = this.getResourcePropertySet().get("Plugin");
        if (typeRP.size() == 0) {
            typeRP.clear();
        }
        this.logger.debug((Object)("the retrieved plugins for scope " + scope + " are " + PluginManager.get(scope).plugins().size()));
        ArrayList<PluginDescription> mapList = new ArrayList<PluginDescription>();
        for (AbstractPlugin plugin : PluginManager.get(scope).plugins().values()) {
            mapList.add(this.getPluginDescription(plugin));
        }
        if (mapList.size() > 0) {
            typeRP.add((Object)new PluginMap(scope.toString(), mapList.toArray(new PluginDescription[mapList.size()])));
        }
    }

    private PluginDescription getPluginDescription(AbstractPlugin plugin) {
        PluginDescription description = new PluginDescription();
        description.setName(plugin.getRepositoryName());
        description.setDescription(plugin.getDescription());
        CapabilityDescription[] capabilities = new CapabilityDescription[plugin.getSupportedCapabilities().size()];
        int i = 0;
        for (Capabilities capability : plugin.getSupportedCapabilities()) {
            String[] properties;
            CapabilityDescription capDescr = new CapabilityDescription();
            capDescr.setName(capability.name());
            try {
                PropertySupport ps = (PropertySupport)capability.getMethod().invoke((Object)plugin, new Object[0]);
                properties = new String[ps.getSupportedProperties().size()];
                int propertiesIndex = 0;
                for (Properties prop : ps.getSupportedProperties()) {
                    properties[propertiesIndex++] = prop.name();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("erro retrieving properties for capability " + capability + " in the " + plugin.getRepositoryName() + " plugin"));
                properties = new String[]{};
            }
            capDescr.setProperties(properties);
            capabilities[i++] = capDescr;
        }
        description.setCapabilities(capabilities);
        String[] searchables = new String[plugin.getSupportedSearch().size()];
        i = 0;
        for (SearchTypes searchable : plugin.getSupportedSearch()) {
            searchables[i++] = searchable.name();
        }
        description.setSearchableBy(searchables);
        return description;
    }
}

