/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanager.manager;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gcube.application.speciesmanager.context.ServiceContext;
import org.gcube.application.speciesmanager.plugin.PluginManager;
import org.gcube.application.speciesmanager.stubs.SearchByCommonNameRequest;
import org.gcube.application.speciesmanager.stubs.SearchByScientificNameRequest;
import org.gcube.application.speciesmanager.stubs.pluginhelper.AbstractPlugin;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Capabilities;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Property;
import org.gcube.application.speciesmanager.stubs.pluginhelper.SearchTypes;
import org.gcube.application.speciesmanager.stubs.pluginhelper.writers.ObjectWriter;
import org.gcube.application.speciesmanager.stubs.writers.RSWrapper;
import org.gcube.application.speciesmanager.stubs.writers.ResultItemWriter;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.utils.logging.GCUBELog;

public class ManagerPT
extends GCUBEPortType {
    GCUBELog logger = new GCUBELog(ManagerPT.class);

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public String searchByScientificName(final SearchByScientificNameRequest request) throws Exception {
        this.logger.debug((Object)"starting search by scientificName");
        final RSWrapper wrapper = new RSWrapper(ServiceContext.getContext().getScope());
        int count = 0;
        Collection<AbstractPlugin> plugins = request.getPluginName() != null ? Collections.singleton(PluginManager.get(ServiceContext.getContext().getScope()).plugins().get(request.getPluginName())) : PluginManager.get(ServiceContext.getContext().getScope()).plugins().values();
        final Property[] properties = this.convertProperties(request.getProperty());
        ArrayList<AbstractPlugin> pluginsWithoutScientificNameSupport = new ArrayList<AbstractPlugin>();
        for (final AbstractPlugin plugin : plugins) {
            if (plugin.getSupportedSearch().contains(SearchTypes.ScientificName)) {
                this.logger.debug((Object)("found a plugin with searchByScientificName capability: " + plugin.getRepositoryName()));
                new Thread(){

                    @Override
                    public void run() {
                        plugin.searchByScientificName(request.getScientificName(), (ObjectWriter)new ResultItemWriter(wrapper, plugin.getRepositoryName()), properties);
                    }
                }.start();
                ++count;
                continue;
            }
            if (!plugin.getSupportedSearch().contains(SearchTypes.CommonName)) continue;
            pluginsWithoutScientificNameSupport.add(plugin);
        }
        if (pluginsWithoutScientificNameSupport.size() > 0) {
            this.logger.trace((Object)("found " + pluginsWithoutScientificNameSupport.size() + " plugins without common name support"));
            final Set<String> mapping = this.retrieveMappingByScientificName(request.getScientificName());
            this.logger.trace((Object)("found " + mapping.size() + " mappings for " + request));
            if (mapping.size() > 0) {
                for (final AbstractPlugin plugin : pluginsWithoutScientificNameSupport) {
                    new Thread(){

                        @Override
                        public void run() {
                            for (String commonName : mapping) {
                                ManagerPT.this.logger.trace((Object)("starting search for plugin " + plugin.getRepositoryName() + " for " + commonName));
                                plugin.searchByCommonName(commonName, (ObjectWriter)new ResultItemWriter(wrapper, plugin.getRepositoryName()), properties);
                            }
                        }
                    }.start();
                    ++count;
                }
            }
        }
        if (count == 0) {
            wrapper.close();
        }
        return wrapper.getLocator().toString();
    }

    public String searchByCommonName(final SearchByCommonNameRequest request) throws Exception {
        this.logger.debug((Object)"starting search by commonName");
        final RSWrapper wrapper = new RSWrapper(ServiceContext.getContext().getScope());
        final Property[] properties = this.convertProperties(request.getProperty());
        int count = 0;
        Collection<AbstractPlugin> plugins = request.getPluginName() != null ? Collections.singleton(PluginManager.get(ServiceContext.getContext().getScope()).plugins().get(request.getPluginName())) : PluginManager.get(ServiceContext.getContext().getScope()).plugins().values();
        ArrayList<AbstractPlugin> pluginsWithoutCommonNameSupport = new ArrayList<AbstractPlugin>();
        for (final AbstractPlugin plugin : plugins) {
            this.logger.debug((Object)("checking plugin " + plugin.getRepositoryName()));
            if (plugin.getSupportedSearch().contains(SearchTypes.CommonName)) {
                this.logger.debug((Object)("found a plugin with searchByCommonName capability: " + plugin.getRepositoryName()));
                new Thread(){

                    @Override
                    public void run() {
                        plugin.searchByCommonName(request.getCommonName(), (ObjectWriter)new ResultItemWriter(wrapper, plugin.getRepositoryName()), properties);
                    }
                }.start();
                ++count;
                continue;
            }
            if (!plugin.getSupportedSearch().contains(SearchTypes.ScientificName)) continue;
            pluginsWithoutCommonNameSupport.add(plugin);
        }
        if (pluginsWithoutCommonNameSupport.size() > 0) {
            this.logger.trace((Object)("found " + pluginsWithoutCommonNameSupport.size() + " plugins without common name support"));
            final Set<String> mapping = this.retrieveMappingByCommonName(request.getCommonName());
            this.logger.trace((Object)("found " + mapping.size() + " mappings for " + request));
            if (mapping.size() > 0) {
                for (final AbstractPlugin plugin : pluginsWithoutCommonNameSupport) {
                    new Thread(){

                        @Override
                        public void run() {
                            for (String scientificName : mapping) {
                                ManagerPT.this.logger.trace((Object)("starting search for plugin " + plugin.getRepositoryName() + " for " + scientificName));
                                plugin.searchByScientificName(scientificName, (ObjectWriter)new ResultItemWriter(wrapper, plugin.getRepositoryName()), properties);
                            }
                        }
                    }.start();
                    ++count;
                }
            }
        }
        if (count == 0) {
            wrapper.close();
        }
        return wrapper.getLocator().toString();
    }

    private Set<String> retrieveMappingByCommonName(String commonName) throws Exception {
        this.logger.debug((Object)("seraching mapping for commonName " + commonName));
        long start = System.currentTimeMillis();
        HashSet<String> mappingSet = new HashSet<String>();
        for (AbstractPlugin plugin : PluginManager.get(ServiceContext.getContext().getScope()).plugins().values()) {
            if (!plugin.getSupportedCapabilities().contains(Capabilities.NamesMapping)) continue;
            mappingSet.addAll(plugin.getNamesMappingInterface().commonNameToScientificNamesMapping(commonName));
        }
        this.logger.debug((Object)("retrieved " + mappingSet.size() + " mapping for commonName " + commonName + " in " + (System.currentTimeMillis() - start)));
        return mappingSet;
    }

    private Set<String> retrieveMappingByScientificName(String scientificName) throws Exception {
        this.logger.debug((Object)("seraching mapping for scientificName " + scientificName));
        HashSet<String> mappingSet = new HashSet<String>();
        for (AbstractPlugin plugin : PluginManager.get(ServiceContext.getContext().getScope()).plugins().values()) {
            if (!plugin.getSupportedCapabilities().contains(Capabilities.NamesMapping)) continue;
            mappingSet.addAll(plugin.getNamesMappingInterface().scientificNameToCommonNamesMapping(scientificName));
        }
        return mappingSet;
    }

    private Property[] convertProperties(String[] stringProperties) {
        if (stringProperties == null) {
            return new Property[0];
        }
        ArrayList<Property> props = new ArrayList<Property>();
        XStream xstream = new XStream();
        String[] stringArray = stringProperties;
        int n = stringProperties.length;
        int n2 = 0;
        while (n2 < n) {
            String stringProp = stringArray[n2];
            props.add((Property)xstream.fromXML(stringProp));
            ++n2;
        }
        return props.toArray(new Property[props.size()]);
    }
}

