package org.visualisation.client.Date;

import java.util.Date;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.sencha.gxt.widget.core.client.event.AddEvent.AddHandler;
import com.sencha.gxt.widget.core.client.form.TextField;


public class PopupDatePicker extends TextBox {
	
	
	private DatePickerWithYearSelector datePicker;
	
	public PopupDatePicker(){
		
		datePicker = new DatePickerWithYearSelector();
		datePicker.addValueChangeHandler(new ValueChangeHandler() {
			public void onValueChange(ValueChangeEvent event) {
				Date date = (Date) event.getValue();
				final DateTimeFormat dateFormat = DateTimeFormat.getFormat("MM/dd/yyyy");
				final String dateString = dateFormat.format(date);
				setValue(dateString);
			}
		});
		
		
		ClickHandler dateButtonHandler = new ClickHandler() {
			public void onClick(ClickEvent event) {
				PopupPanel popupPanel = new PopupPanel(true);
				popupPanel.setStyleName("border:none;");
				popupPanel.add(datePicker);
				popupPanel.setAutoHideEnabled(true);
//				popupPanel.setModal(true);
				popupPanel.getElement().getStyle().setZIndex(Integer.MAX_VALUE);
				popupPanel.setPopupPosition(getAbsoluteLeft(), getAbsoluteTop() + getOffsetHeight());
				popupPanel.show();
			}
		};
		
		addClickHandler(dateButtonHandler);

		
	}
	
	

        
}
