/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.perform.service.engine.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.gcube.application.perform.service.engine.DataBaseManager;
import org.gcube.application.perform.service.engine.MappingManager;
import org.gcube.application.perform.service.engine.impl.Queries;
import org.gcube.application.perform.service.engine.impl.Query;
import org.gcube.application.perform.service.engine.model.BeanNotFound;
import org.gcube.application.perform.service.engine.model.DBField;
import org.gcube.application.perform.service.engine.model.DBQueryDescriptor;
import org.gcube.application.perform.service.engine.model.InternalException;
import org.gcube.application.perform.service.engine.model.anagraphic.Batch;
import org.gcube.application.perform.service.engine.model.anagraphic.Farm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingManagerImpl
implements MappingManager {
    private static final Logger log = LoggerFactory.getLogger(MappingManagerImpl.class);

    public Batch getBatch(DBQueryDescriptor desc) throws SQLException, InternalException {
        DataBaseManager db = DataBaseManager.get();
        try (Connection conn = db.getConnection();){
            conn.setAutoCommit(true);
            Query getQuery = Queries.GET_BATCH_BY_DESCRIPTIVE_KEY;
            PreparedStatement psSearch = getQuery.get(conn, desc);
            ResultSet rs = psSearch.executeQuery();
            if (rs.next()) {
                Batch batch = Queries.rowToBatch((ResultSet)rs);
                return batch;
            }
            log.trace("Registering new Batch from condition {}", (Object)desc);
            desc.add((DBField)DBField.Batch.fields.get("uuid"), (Object)UUID.randomUUID());
            PreparedStatement psInsert = Queries.INSERT_BATCH.get(conn, desc);
            psInsert.executeUpdate();
            rs = psSearch.executeQuery();
            if (rs.next()) {
                Batch batch = Queries.rowToBatch((ResultSet)rs);
                return batch;
            }
            throw new BeanNotFound(String.format("Unable to find Bean with ", desc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Farm getFarm(DBQueryDescriptor desc) throws SQLException, InternalException {
        DataBaseManager db = DataBaseManager.get();
        try (Connection conn = db.getConnection();){
            ResultSet rs;
            PreparedStatement psGet = null;
            DBField IDField = (DBField)DBField.Farm.fields.get("id");
            if (desc.getCondition().containsKey(IDField)) {
                psGet = Queries.GET_FARM_BY_ID.get(conn, desc);
            }
            if (!(rs = psGet.executeQuery()).next()) {
                throw new BeanNotFound("Farm not found. Condition was " + desc);
            }
            Farm farm = Queries.rowToFarm((ResultSet)rs);
            return farm;
        }
    }
}

