/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.perform.service.engine.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.gcube.application.perform.service.LocalConfiguration;
import org.gcube.application.perform.service.engine.DataBaseManager;
import org.gcube.application.perform.service.engine.Importer;
import org.gcube.application.perform.service.engine.PerformanceManager;
import org.gcube.application.perform.service.engine.dm.DMException;
import org.gcube.application.perform.service.engine.dm.DMUtils;
import org.gcube.application.perform.service.engine.dm.ImporterMonitor;
import org.gcube.application.perform.service.engine.impl.Queries;
import org.gcube.application.perform.service.engine.model.BeanNotFound;
import org.gcube.application.perform.service.engine.model.DBField;
import org.gcube.application.perform.service.engine.model.DBQueryDescriptor;
import org.gcube.application.perform.service.engine.model.InternalException;
import org.gcube.application.perform.service.engine.model.InvalidRequestException;
import org.gcube.application.perform.service.engine.model.importer.ImportRequest;
import org.gcube.application.perform.service.engine.model.importer.ImportRoutineDescriptor;
import org.gcube.application.perform.service.engine.model.importer.ImportStatus;
import org.gcube.application.perform.service.engine.utils.CommonUtils;
import org.gcube.application.perform.service.engine.utils.ScopeUtils;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.data.analysis.dataminermanagercl.server.monitor.DMMonitorListener;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationId;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImporterImpl
implements Importer {
    private static final Logger log = LoggerFactory.getLogger(ImporterImpl.class);
    @Inject
    private PerformanceManager performance;

    private static final String getHostname() {
        try {
            ApplicationContext context = ContextProvider.get();
            ContainerConfiguration configuration = context.container().configuration();
            return configuration.hostname();
        }
        catch (Throwable t) {
            log.warn("UNABLE TO GET HOSTNAME. This should happen only in debug mode.");
            return "localhost";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws InternalException {
        try {
            log.info("Initializing IMPORTER");
            DataBaseManager db = DataBaseManager.get();
            try (Connection conn = db.getConnection();){
                conn.setAutoCommit(true);
                String hostname = ImporterImpl.getHostname();
                DBField lockField = (DBField)DBField.ImportRoutine.fields.get("lock");
                PreparedStatement psOrphans = Queries.ORPHAN_IMPORTS.get(conn, new DBQueryDescriptor(lockField, (Object)hostname));
                PreparedStatement psAcquire = Queries.ACQUIRE_IMPORT_ROUTINE.prepare(conn);
                ResultSet rsOrphans = psOrphans.executeQuery();
                long monitoredCount = 0L;
                while (rsOrphans.next()) {
                    Long id = rsOrphans.getLong("id");
                    try {
                        ImportRoutineDescriptor desc = Queries.rowToDescriptor((ResultSet)rsOrphans);
                        DBQueryDescriptor acquireDesc = new DBQueryDescriptor().add(lockField, (Object)hostname).add((DBField)DBField.ImportRoutine.fields.get("id"), (Object)id);
                        Queries.ACQUIRE_IMPORT_ROUTINE.fill(psAcquire, acquireDesc);
                        if (psAcquire.executeUpdate() <= 0) continue;
                        log.debug("Acquired {} ", (Object)id);
                        log.debug("Setting stored token.. ");
                        SecurityTokenProvider.instance.set(CommonUtils.decryptString((String)desc.getCaller()));
                        this.monitor(desc);
                        ++monitoredCount;
                    }
                    catch (Throwable t) {
                        log.warn("Unable to monitor orphan with ID {} ", (Object)id, (Object)t);
                    }
                }
                log.info("Acquired {} import executions for monitoring", (Object)monitoredCount);
            }
        }
        catch (Throwable t) {
            log.warn("Unexpected Error while trying to check orphan import routines");
            throw new InternalException(t);
        }
    }

    public ImportRoutineDescriptor importExcel(ImportRequest request) throws DMException, SQLException, InternalException {
        log.debug("Submitting {} ", (Object)request);
        ComputationId id = this.submit(request);
        log.debug("Registering {} computationID {} ", (Object)request, (Object)id);
        ImportRoutineDescriptor desc = this.register(id, request);
        log.debug("Monitoring {} computationID {} ", (Object)desc, (Object)id);
        this.monitor(desc);
        return this.getDescriptorById(desc.getId());
    }

    private void monitor(ImportRoutineDescriptor desc) throws DMException {
        log.debug("Monitoring {} ", (Object)desc);
        DMUtils.monitor((ComputationId)DMUtils.getComputation((ImportRoutineDescriptor)desc), (DMMonitorListener)new ImporterMonitor(this.performance, desc));
    }

    private ComputationId submit(ImportRequest request) throws DMException, InvalidRequestException {
        log.debug("Preparing DM Parameters from request : {} ", (Object)request);
        HashMap<String, String> parameters = new HashMap<String, String>();
        try {
            parameters.put("InputData", request.getSource());
            parameters.put("BatchType", request.getBatchType());
            parameters.put("FarmID", request.getFarmId().toString());
        }
        catch (Throwable t) {
            throw new InvalidRequestException("Invalid request : " + request, t);
        }
        return DMUtils.submitJob((String)LocalConfiguration.getProperty((String)"dm.importer.computationid"), parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImportRoutineDescriptor register(ComputationId computationId, ImportRequest request) throws SQLException, InternalException {
        DBQueryDescriptor insertionRow = new DBQueryDescriptor().add((DBField)DBField.ImportRoutine.fields.get("batch_type"), (Object)request.getBatchType()).add((DBField)DBField.ImportRoutine.fields.get("caller"), (Object)CommonUtils.encryptString((String)ScopeUtils.getCaller())).add((DBField)DBField.ImportRoutine.fields.get("computation_id"), (Object)computationId.getId()).add((DBField)DBField.ImportRoutine.fields.get("computation_opid"), (Object)computationId.getOperatorId()).add((DBField)DBField.ImportRoutine.fields.get("computation_opname"), (Object)computationId.getOperatorName()).add((DBField)DBField.ImportRoutine.fields.get("computation_req"), (Object)computationId.getEquivalentRequest()).add((DBField)DBField.ImportRoutine.fields.get("computation_url"), (Object)computationId.getUrlId()).add((DBField)DBField.ImportRoutine.fields.get("farmid"), (Object)request.getFarmId()).add((DBField)DBField.ImportRoutine.fields.get("lock"), (Object)ImporterImpl.getHostname()).add((DBField)DBField.ImportRoutine.fields.get("sourceurl"), (Object)request.getSource()).add((DBField)DBField.ImportRoutine.fields.get("sourceversion"), (Object)request.getVersion()).add((DBField)DBField.ImportRoutine.fields.get("start_time"), (Object)Timestamp.from(Instant.now())).add((DBField)DBField.ImportRoutine.fields.get("status"), (Object)ImportStatus.ACCEPTED.toString());
        DataBaseManager db = DataBaseManager.get();
        conn.setAutoCommit(true);
        try (Connection conn = db.getConnection();){
            PreparedStatement ps = Queries.INSERT_ROUTINE.prepare(conn, 1);
            Queries.INSERT_ROUTINE.fill(ps, insertionRow);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            PreparedStatement psGet = Queries.GET_IMPORT_ROUTINE_BY_ID.get(conn, new DBQueryDescriptor().add((DBField)DBField.ImportRoutine.fields.get("id"), (Object)rs.getLong("id")));
            ResultSet rsGet = psGet.executeQuery();
            rsGet.next();
            ImportRoutineDescriptor importRoutineDescriptor = Queries.rowToDescriptor((ResultSet)rsGet);
            return importRoutineDescriptor;
        }
    }

    private ImportRoutineDescriptor getDescriptorById(Long id) throws SQLException, InternalException {
        DataBaseManager db = DataBaseManager.get();
        try (Connection conn = db.getConnection();){
            PreparedStatement ps = Queries.GET_IMPORT_ROUTINE_BY_ID.get(conn, new DBQueryDescriptor().add((DBField)DBField.ImportRoutine.fields.get("id"), (Object)id));
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ImportRoutineDescriptor importRoutineDescriptor = Queries.rowToDescriptor((ResultSet)rs);
                return importRoutineDescriptor;
            }
            throw new BeanNotFound("Unable to find Routine with ID " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ImportRoutineDescriptor> getDescriptors(DBQueryDescriptor desc) throws SQLException, InternalException {
        DataBaseManager db = DataBaseManager.get();
        try (Connection conn = db.getConnection();){
            PreparedStatement ps = Queries.FILTER_IMPORTS.get(conn, desc);
            ResultSet rs = ps.executeQuery();
            ArrayList<ImportRoutineDescriptor> toReturn = new ArrayList<ImportRoutineDescriptor>();
            while (rs.next()) {
                toReturn.add(Queries.rowToDescriptor((ResultSet)rs));
            }
            ArrayList<ImportRoutineDescriptor> arrayList = toReturn;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ImportRoutineDescriptor> getGroupedDescriptors(DBQueryDescriptor desc) throws SQLException, InternalException {
        DataBaseManager db = DataBaseManager.get();
        try (Connection conn = db.getConnection();){
            PreparedStatement ps = Queries.LAST_GROUPED_IMPORTS.get(conn, desc);
            ResultSet rs = ps.executeQuery();
            ArrayList<ImportRoutineDescriptor> toReturn = new ArrayList<ImportRoutineDescriptor>();
            while (rs.next()) {
                toReturn.add(Queries.rowToDescriptor((ResultSet)rs));
            }
            ArrayList<ImportRoutineDescriptor> arrayList = toReturn;
            return arrayList;
        }
    }
}

