/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.perform.service.engine.utils;

import java.util.List;
import org.gcube.application.perform.service.engine.model.DatabaseConnectionDescriptor;
import org.gcube.application.perform.service.engine.model.ISQueryDescriptor;
import org.gcube.application.perform.service.engine.model.InternalException;
import org.gcube.application.perform.service.engine.utils.CommonUtils;
import org.gcube.application.perform.service.engine.utils.ScopeUtils;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISUtils {
    private static final Logger log = LoggerFactory.getLogger(ISUtils.class);
    private static String fixedToken = null;

    public static DatabaseConnectionDescriptor queryForDatabase(ISQueryDescriptor desc) throws InternalException {
        DiscoveryClient client;
        List found;
        if (fixedToken != null) {
            SecurityTokenProvider.instance.set(fixedToken);
        }
        log.debug("Querying for Service Endpoints {} ", (Object)desc, (Object)ScopeUtils.getCurrentScope());
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        if (desc.getCategory() != null) {
            query.addCondition("$resource/Profile/Category/text() eq '" + desc.getCategory() + "'");
        }
        if (desc.getPlatformName() != null) {
            query.addCondition("$resource/Profile/Platform/Name/text() eq '" + desc.getPlatformName() + "'");
        }
        if (desc.getResourceName() != null) {
            query.addCondition("$resource/Profile/Name/text() eq '" + desc.getResourceName() + "'");
        }
        if ((found = (client = ICFactory.clientFor(ServiceEndpoint.class)).submit((Query)query)).size() == 0) {
            throw new InternalException("Unable to find Service Endpoint " + desc + " in " + ScopeUtils.getCurrentScope());
        }
        if (found.size() > 1) {
            log.warn("Multiple Endpoints " + desc + " found in " + ScopeUtils.getCurrentScope());
        }
        ServiceEndpoint.AccessPoint point = (ServiceEndpoint.AccessPoint)((ServiceEndpoint)found.get(0)).profile().accessPoints().iterator().next();
        String url = "jdbc:postgresql://" + point.address() + "/" + point.name();
        DatabaseConnectionDescriptor toReturn = new DatabaseConnectionDescriptor(point.username(), url, CommonUtils.decryptString((String)point.password()));
        log.debug("Going to use DB : " + toReturn);
        return toReturn;
    }

    public static final void setFixedToken(String toSet) {
        log.warn("SETTING FIXED TOKEN. THIS SHOULD HAPPEN ONLY IN DEBUG MODE.");
        fixedToken = toSet;
    }
}

