/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.perform.service.engine.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.gcube.application.perform.service.LocalConfiguration;
import org.gcube.application.perform.service.engine.DataBaseManager;
import org.gcube.application.perform.service.engine.model.DatabaseConnectionDescriptor;
import org.gcube.application.perform.service.engine.model.ISQueryDescriptor;
import org.gcube.application.perform.service.engine.model.InternalException;
import org.gcube.application.perform.service.engine.utils.ISUtils;
import org.gcube.application.perform.service.engine.utils.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataBaseManagerImpl
implements DataBaseManager {
    private static final Logger log;
    private static ConcurrentHashMap<String, DataSource> datasources;
    private static ConcurrentHashMap<String, DatabaseConnectionDescriptor> databases;

    static {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            System.err.println("PERFORM SERVICE - UNABLE TO REGISTER postgresql DRIVER");
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
        log = LoggerFactory.getLogger(DataBaseManagerImpl.class);
        datasources = new ConcurrentHashMap();
        databases = new ConcurrentHashMap();
    }

    private synchronized DatabaseConnectionDescriptor getDB() throws InternalException {
        if (!databases.containsKey(ScopeUtils.getCurrentScope())) {
            databases.put(ScopeUtils.getCurrentScope(), ISUtils.queryForDatabase((ISQueryDescriptor)new ISQueryDescriptor(LocalConfiguration.getProperty((String)"mapping-db.ep.name"), null, LocalConfiguration.getProperty((String)"mapping-db.ep.category"))));
        }
        return (DatabaseConnectionDescriptor)databases.get(ScopeUtils.getCurrentScope());
    }

    public Connection getConnection() throws SQLException, InternalException {
        DataSource ds = this.getDataSource();
        Connection conn = ds.getConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    private synchronized DataSource getDataSource() throws InternalException {
        DatabaseConnectionDescriptor dbDescriptor = this.getDB();
        if (!datasources.containsKey(dbDescriptor.getUrl())) {
            datasources.put(dbDescriptor.getUrl(), DataBaseManagerImpl.setupDataSource((DatabaseConnectionDescriptor)dbDescriptor));
        }
        return (DataSource)datasources.get(dbDescriptor.getUrl());
    }

    private static DataSource setupDataSource(DatabaseConnectionDescriptor db) {
        log.trace("Setting up data source for {} ", (Object)db);
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxIdle(Integer.parseInt(LocalConfiguration.getProperty((String)"db.pools.max_idle")));
        poolConfig.setMaxTotal(Integer.parseInt(LocalConfiguration.getProperty((String)"db.pools.max_total")));
        poolConfig.setMinIdle(Integer.parseInt(LocalConfiguration.getProperty((String)"db.pools.min_total")));
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(db.getUrl(), db.getUsername(), db.getPassword());
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory);
        poolableConnectionFactory.setPool((ObjectPool)connectionPool);
        PoolingDataSource dataSource = new PoolingDataSource((ObjectPool)connectionPool);
        return dataSource;
    }
}

