/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.perform.service.rest;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.gcube.application.perform.service.PerformServiceManager;
import org.gcube.application.perform.service.engine.PerformanceManager;
import org.gcube.application.perform.service.engine.model.CSVExportRequest;
import org.gcube.application.perform.service.engine.model.InternalException;
import org.gcube.application.perform.service.engine.model.InvalidRequestException;
import org.gcube.application.perform.service.engine.model.importer.AnalysisType;
import org.gcube.application.perform.service.rest.InterfaceCommons;
import org.gcube.smartgears.annotations.ManagedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="performance")
@ManagedBy(value=PerformServiceManager.class)
public class Performance {
    private static final Logger log = LoggerFactory.getLogger(Performance.class);
    @Inject
    private PerformanceManager perform;

    @GET
    @Produces(value={"application/json"})
    public Map<String, String> getPerformance(@Context UriInfo info) {
        try {
            MultivaluedMap parameters = info.getQueryParameters();
            log.info("Forming request from {}", (Object)parameters);
            String batchType = (String)InterfaceCommons.getParameter((MultivaluedMap)parameters, (String)"batch_type", (boolean)true).get(0);
            CSVExportRequest request = new CSVExportRequest(new AnalysisType(batchType, batchType));
            request.addAreas((Collection)InterfaceCommons.getParameter((MultivaluedMap)parameters, (String)"area", (boolean)false));
            request.addQuarters((Collection)InterfaceCommons.getParameter((MultivaluedMap)parameters, (String)"quarter", (boolean)false));
            List farmidsString = InterfaceCommons.getParameter((MultivaluedMap)parameters, (String)"farmid", (boolean)false);
            log.debug("FARMIDS : ", (Object)farmidsString);
            for (String s : farmidsString) {
                log.debug("Parsing {} ", (Object)s);
                request.addFarmId(Long.valueOf(Long.parseLong(s)));
            }
            request.addSpecies((Collection)InterfaceCommons.getParameter((MultivaluedMap)parameters, (String)"speciesid", (boolean)false));
            request.addPeriods((Collection)InterfaceCommons.getParameter((MultivaluedMap)parameters, (String)"period", (boolean)false));
            log.debug("Export request : {} ", (Object)request);
            return this.perform.generateCSV(request);
        }
        catch (NumberFormatException numberFormatException) {
            throw new WebApplicationException(String.format("Unable to parse parameters.", new Object[0]), Response.Status.BAD_REQUEST);
        }
        catch (SQLException e) {
            log.debug("Exception while getting Batch", (Throwable)e);
            throw new WebApplicationException("Unexpected Exception occurred while dealing with database.", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (InvalidRequestException e) {
            log.debug("Exception while getting Batch", (Throwable)e);
            throw new WebApplicationException("Unable to search for Batch. ", (Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (InternalException e) {
            log.warn("Unexpected Exception while getting Batch", (Throwable)e);
            throw new WebApplicationException("Unexpected Exception.", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Throwable t) {
            log.warn("Unexpected Exception while getting Batch", t);
            throw new WebApplicationException("Unexpected Exception.", t, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="statistics/{batch_type}")
    public Map<String, String> getStatistics(@PathParam(value="batch_type") String batchType) {
        throw new WebApplicationException("Method Unavailable.", Response.Status.NOT_IMPLEMENTED);
    }
}

