/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.enabling.Impl;

import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.ComputationalInfrastructure;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.AquaMapsServiceCall;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.AquaMapsServiceInterface;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.DataManagementCall;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.DataManagementInterface;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.PublisherInterface;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.PublisherServiceCall;
import org.gcube.application.aquamaps.enabling.Configuration;
import org.gcube.application.aquamaps.enabling.Impl.crawler.CrawlerMode;
import org.gcube.application.aquamaps.enabling.Impl.crawler.ISCrawler;
import org.gcube.application.aquamaps.enabling.ParameterNotFoundException;
import org.gcube.application.aquamaps.enabling.ScopeNotFoundException;
import org.gcube.application.aquamaps.enabling.model.DBDescriptor;
import org.gcube.application.aquamaps.enabling.model.DataSourceDescriptor;
import org.gcube.application.aquamaps.enabling.model.GeoServerDescriptor;
import org.gcube.application.aquamaps.enabling.model.VODescriptor;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;

public class ConfigurationImpl
implements Configuration {
    protected static GCUBELog logger = new GCUBELog(ConfigurationImpl.class);
    private static final int DEFAULT_REFRESH_INTERVAL = 10;
    private static final String FETCH_INTERVAL_MINUTES = "FETCH_INTERVAL_MINUTES";
    private static final String FORCE_COLLECTOR_TIME = "FORCE_COLLECTOR_TIME";
    private static final String FORCE_COLLECTOR = "FORCE_COLLECTOR";
    private ISCrawler crawler;
    private static ConfigurationImpl impl = null;

    public static synchronized Configuration getSingle(GCUBEScope defaultScope) throws Exception {
        if (impl == null) {
            impl = new ConfigurationImpl(CrawlerMode.SINGLESCOPE, defaultScope);
        } else {
            logger.debug((Object)("Instance was already created, crawler is " + ConfigurationImpl.impl.crawler.getClass().getName()));
        }
        return impl;
    }

    public static synchronized Configuration get(CrawlerMode mode) throws Exception {
        if (impl == null) {
            impl = new ConfigurationImpl(mode, null);
        } else {
            logger.debug((Object)("Instance was already created, crawler is " + ConfigurationImpl.impl.crawler.getClass().getName()));
        }
        return impl;
    }

    private ConfigurationImpl(CrawlerMode mode, GCUBEScope defaultScope) throws Exception {
        Integer interval = 10;
        Integer gcInterval = 10;
        Boolean enableGCForcing = false;
        try {
            Properties prop = new Properties();
            prop.load(Configuration.class.getResourceAsStream("util/resources/config.properties"));
            interval = Integer.parseInt(prop.getProperty(FETCH_INTERVAL_MINUTES));
            gcInterval = Integer.parseInt(prop.getProperty(FORCE_COLLECTOR_TIME));
            enableGCForcing = Boolean.parseBoolean(prop.getProperty(FORCE_COLLECTOR));
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to read properties file under resources package. Gonna use default (" + interval + ")"), (Throwable)e);
        }
        this.crawler = ISCrawler.get(interval, gcInterval, enableGCForcing, mode, defaultScope);
    }

    protected VODescriptor getVO(GCUBEScope scope) throws ScopeNotFoundException {
        VODescriptor toReturn = null;
        if (this.crawler.getInfrastructureMap().containsKey(scope.toString())) {
            toReturn = this.crawler.getInfrastructureMap().get(scope.toString());
        }
        if (toReturn == null) {
            throw new ScopeNotFoundException();
        }
        return toReturn;
    }

    @Override
    public DataManagementInterface getDMInterface(GCUBEScope scope) throws ParameterNotFoundException, ScopeNotFoundException, Exception {
        try {
            return DataManagementCall.getCall((GCUBEScope)scope, (String)this.getVO(scope).getDmEndpoint(), (boolean)false);
        }
        catch (ScopeNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParameterNotFoundException();
        }
    }

    @Override
    public AquaMapsServiceInterface getAMInterface(GCUBEScope scope) throws ParameterNotFoundException, ScopeNotFoundException, Exception {
        try {
            return AquaMapsServiceCall.getCall((GCUBEScope)scope, (String)this.getVO(scope).getAmEndpoint(), (boolean)false);
        }
        catch (ScopeNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParameterNotFoundException();
        }
    }

    @Override
    public List<GeoServerDescriptor> getGeoServers(GCUBEScope scope) throws ParameterNotFoundException, ScopeNotFoundException {
        List<GeoServerDescriptor> toReturn = this.getVO(scope).getGeoServers();
        if (toReturn == null || toReturn.size() == 0) {
            throw new ParameterNotFoundException();
        }
        return toReturn;
    }

    @Override
    public String getServiceConfigurationParameter(GCUBEScope scope, String parameter) throws ParameterNotFoundException, ScopeNotFoundException {
        String toReturn = this.getVO(scope).getServiceParam(parameter);
        if (toReturn == null) {
            throw new ParameterNotFoundException();
        }
        return toReturn;
    }

    @Override
    public List<ComputationalInfrastructure> getAvailableInfrastructures(GCUBEScope scope) throws ParameterNotFoundException, ScopeNotFoundException {
        List<ComputationalInfrastructure> toReturn = this.getVO(scope).getInfrastructures();
        if (toReturn == null || toReturn.size() == 0) {
            throw new ParameterNotFoundException();
        }
        return toReturn;
    }

    @Override
    public Set<GCUBEScope> getAvailableScopes() throws Exception {
        HashSet<GCUBEScope> toReturn = new HashSet<GCUBEScope>();
        for (String scopeName : this.crawler.getInfrastructureMap().keySet()) {
            toReturn.add(GCUBEScope.getScope((String)scopeName));
        }
        return toReturn;
    }

    @Override
    public String getBackendUrl(GCUBEScope scope, String backend) throws ParameterNotFoundException, ScopeNotFoundException {
        String toReturn = this.getVO(scope).getBackendsUrl().get(backend);
        if (toReturn == null) {
            throw new ParameterNotFoundException();
        }
        return toReturn;
    }

    @Override
    public DBDescriptor getGeoServerDb(GCUBEScope scope) throws ParameterNotFoundException, ScopeNotFoundException {
        DBDescriptor toReturn = this.getVO(scope).getGeoDb();
        if (toReturn == null) {
            throw new ParameterNotFoundException();
        }
        return toReturn;
    }

    @Override
    public DBDescriptor getInternalDB(GCUBEScope scope) throws ParameterNotFoundException, ScopeNotFoundException {
        DBDescriptor descriptor = this.getVO(scope).getInternalDB();
        if (descriptor == null) {
            throw new ParameterNotFoundException();
        }
        return descriptor;
    }

    @Override
    public DataSourceDescriptor getGeoNetwork(GCUBEScope scope) throws ParameterNotFoundException, ScopeNotFoundException {
        DataSourceDescriptor descriptor = this.getVO(scope).getGeoNetwork();
        if (descriptor == null) {
            throw new ParameterNotFoundException();
        }
        return descriptor;
    }

    @Override
    public GeoServerDescriptor getGeoServerByEntryPoint(GCUBEScope scope, String entryPoint) throws ParameterNotFoundException, ScopeNotFoundException {
        GeoServerDescriptor toReturn = this.getVO(scope).getGeoServerByEntryPoint(entryPoint);
        if (toReturn == null) {
            throw new ParameterNotFoundException();
        }
        return toReturn;
    }

    @Override
    public DBDescriptor getPublisherDataBase(GCUBEScope scope) throws ParameterNotFoundException, ScopeNotFoundException {
        DBDescriptor descriptor = this.getVO(scope).getPublisherDB();
        if (descriptor == null) {
            throw new ParameterNotFoundException();
        }
        return descriptor;
    }

    @Override
    public PublisherInterface getPublisherInterface(GCUBEScope scope) throws ParameterNotFoundException, ScopeNotFoundException, Exception {
        try {
            return PublisherServiceCall.getCall((GCUBEScope)scope, (String)this.getVO(scope).getPubEndpoint(), (boolean)false);
        }
        catch (ScopeNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParameterNotFoundException();
        }
    }

    @Override
    public Set<String> getAvailableScopeNames() throws Exception {
        return this.crawler.getInfrastructureMap().keySet();
    }
}

