/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.images;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.DataManagement;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.Maps;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.Publisher;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.BulkItem;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.ItemResources;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.xstream.AquaMapsXStream;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceType;
import org.gcube.application.aquamaps.images.Common;
import org.gcube.application.aquamaps.images.SpeciesCSVLineProcessor;
import org.gcube.application.aquamaps.images.model.MapItem;
import org.gcube.application.aquamaps.images.model.SpeciesInfo;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeciesInfoImportThread
extends Thread {
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private static SpeciesInfoImportThread instance;
    private static final Logger logger;
    private Properties props;

    static {
        logger = LoggerFactory.getLogger(SpeciesInfoImportThread.class);
    }

    public static synchronized SpeciesInfoImportThread start(Properties prop) {
        if (instance == null) {
            instance = new SpeciesInfoImportThread(prop);
        }
        return instance;
    }

    private SpeciesInfoImportThread(Properties props) {
        this.props = props;
        this.start();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        while (true) {
            block29: {
                configuration = (Hashtable)this.props.clone();
                toDelete = new ArrayList<File>();
                try {
                    SpeciesInfoImportThread.logger.debug("Using configuration : " + configuration);
                    scope = (String)configuration.get("SCOPE");
                    ScopeProvider.instance.set(scope);
                    SpeciesInfoImportThread.logger.trace("Fetching info in scope " + scope);
                    maps = (Maps)AbstractPlugin.maps().build();
                    pub = (Publisher)AbstractPlugin.publisher().build();
                    dmService = (DataManagement)AbstractPlugin.dataManagement().build();
                    hspenID = 0;
                    for (Field f : dmService.getDefaultSources()) {
                        if (!f.name().equals("" + ResourceType.HSPEN)) continue;
                        hspenID = f.getValueAsInteger();
                        SpeciesInfoImportThread.logger.debug("Using hspen id " + hspenID);
                        break;
                    }
                    toRead = maps.getCSVSpecies(hspenID, null, null);
                    toDelete.add(toRead);
                    processor = new CSVReaderProcessor();
                    processor.setDelimiter(',');
                    processor.setHasHeader(true);
                    lineProcessor = new SpeciesCSVLineProcessor();
                    reader = new InputStreamReader((InputStream)new FileInputStream(toRead), Charset.defaultCharset());
                    processor.processStream((Reader)reader, (CSVLineProcessor)lineProcessor);
                    lastUpdate = Common.get().getLastCompletedUpdate();
                    performedUpdateTime = System.currentTimeMillis();
                    SpeciesInfoImportThread.logger.trace("Fetched " + lineProcessor.getCount() + " species, getting maps generated after " + SpeciesInfoImportThread.format.format(new Date(lastUpdate)));
                    bulkMaps = pub.getBulkUpdates(true, false, null, lastUpdate);
                    toDelete.add(bulkMaps);
                    stream = AquaMapsXStream.getXMLInstance();
                    ois = stream.createObjectInputStream((InputStream)new FileInputStream(bulkMaps));
                    speciesDao = Common.get().getSpeciesDao();
                    mapDao = Common.get().getMapDao();
                    bulkCount = 0L;
                    updateCount = 0L;
                    insertCount = 0L;
                    try {
                        try {
                            while (true) {
                                try {
                                    block23: while (true) {
                                        item = (BulkItem)ois.readObject();
                                        ++bulkCount;
                                        scientificName = ((SpeciesInfo)speciesDao.queryForId((Object)item.getSpeciesId())).getScientificName();
                                        var30_42 = item.getResources().entrySet().iterator();
                                        while (true) {
                                            if (!var30_42.hasNext()) continue block23;
                                            entry = var30_42.next();
                                            res = (ItemResources)entry.getValue();
                                            mapItem = new MapItem(((Integer)entry.getKey()).intValue(), item.getSpeciesId(), scientificName, res.getStandardImgUri(), res.getStandardLayerId());
                                            inserted = Common.get().insertOrUpdateMapInfoByCoverage(mapItem);
                                            if (inserted) {
                                                ++insertCount;
                                                continue;
                                            }
                                            ++updateCount;
                                        }
                                        break;
                                    }
                                }
                                catch (EOFException e) {
                                    throw e;
                                }
                                catch (Exception e) {
                                    SpeciesInfoImportThread.logger.warn("Unable to load map info", (Throwable)e);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (EOFException var27_23) {
                            IOUtils.closeQuietly((InputStream)ois);
                        }
                    }
                    catch (Throwable var34_46) {
                        IOUtils.closeQuietly((InputStream)ois);
                        throw var34_46;
                    }
                    SpeciesInfoImportThread.logger.debug("Parsed " + bulkCount + " bulkItems, inserted " + insertCount + " map entries, updated " + updateCount);
                    SpeciesInfoImportThread.logger.debug("Current map count : " + mapDao.countOf());
                    Common.get().setLastConfiguration((Map)configuration);
                    Common.get().setLastCompletedUpdate(Long.valueOf(performedUpdateTime));
                    break block29;
                }
                catch (Throwable e) {
                    SpeciesInfoImportThread.logger.error("Unexpected Error ", e);
                    ** for (f : toDelete)
                }
lbl-1000:
                // 1 sources

                {
                    FileUtils.deleteQuietly((File)f);
                    continue;
                }
lbl84:
                // 1 sources

                try {
                    minutes = Long.parseLong((String)configuration.get("FETCH_ROUTINE_INTERVAL_MINUTES"));
                    SpeciesInfoImportThread.logger.trace("Going to execute again in " + minutes + " min");
                    SpeciesInfoImportThread.sleep((long)(minutes * 60L * 1000L));
                }
                catch (InterruptedException minutes) {
                }
                catch (Throwable t) {
                    SpeciesInfoImportThread.logger.error("Unexpected exception ", t);
                }
                continue;
                catch (Throwable var35_47) {
                    ** for (f : toDelete)
                }
lbl-1000:
                // 1 sources

                {
                    FileUtils.deleteQuietly((File)f);
                    continue;
                }
lbl99:
                // 1 sources

                try {
                    minutes = Long.parseLong((String)configuration.get("FETCH_ROUTINE_INTERVAL_MINUTES"));
                    SpeciesInfoImportThread.logger.trace("Going to execute again in " + minutes + " min");
                    SpeciesInfoImportThread.sleep((long)(minutes * 60L * 1000L));
                }
                catch (InterruptedException minutes) {
                }
                catch (Throwable t) {
                    SpeciesInfoImportThread.logger.error("Unexpected exception ", t);
                }
                throw var35_47;
            }
            for (File f : toDelete) {
                FileUtils.deleteQuietly((File)f);
            }
            try {
                minutes = Long.parseLong((String)configuration.get("FETCH_ROUTINE_INTERVAL_MINUTES"));
                SpeciesInfoImportThread.logger.trace("Going to execute again in " + minutes + " min");
                SpeciesInfoImportThread.sleep((long)(minutes * 60L * 1000L));
                continue;
            }
            catch (InterruptedException minutes) {
                continue;
            }
            catch (Throwable t) {
                SpeciesInfoImportThread.logger.error("Unexpected exception ", t);
                continue;
            }
            break;
        }
    }
}

