/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.images;

import com.j256.ormlite.dao.CloseableIterator;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.application.aquamaps.images.Common;
import org.gcube.application.aquamaps.images.model.MapItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Report
extends HttpServlet {
    private static final long serialVersionUID = 2486605867155769417L;
    private static final Logger logger = LoggerFactory.getLogger(Report.class);
    private static DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block13: {
            CloseableIterator it = null;
            try {
                try {
                    Common com = Common.get();
                    it = com.getMapDao().closeableIterator();
                    PrintWriter writer = resp.getWriter();
                    long totalCount = com.getMapDao().countOf();
                    while (it.hasNext()) {
                        writer.println(((MapItem)it.next()).toString());
                    }
                    writer.println("Total count " + totalCount);
                    writer.println("Last completed routine " + df.format(new Date(com.getLastCompletedUpdate())));
                    writer.println("Last used configuration");
                    Map lastConfiguration = com.getLastConfiguration();
                    writer.println("Update interval in minutes " + (String)lastConfiguration.get("FETCH_ROUTINE_INTERVAL_MINUTES"));
                    writer.println("GCUBE Scope " + (String)lastConfiguration.get("SCOPE"));
                    writer.println("Suitable hspec id " + (String)lastConfiguration.get("SUITABLE_ID"));
                    writer.println("Suitable 2050 hspec id " + (String)lastConfiguration.get("SUITABLE_2050_ID"));
                    writer.println("Native hspec id " + (String)lastConfiguration.get("NATIVE_ID"));
                    writer.println("Native 2050 hspec id " + (String)lastConfiguration.get("NATIVE_2050_ID"));
                    writer.println("Current configuration");
                    writer.println("Update interval in minutes " + com.getProperty("FETCH_ROUTINE_INTERVAL_MINUTES"));
                    writer.println("GCUBE Scope " + com.getProperty("SCOPE"));
                    writer.println("Suitable hspec id " + com.getProperty("SUITABLE_ID"));
                    writer.println("Suitable 2050 hspec id " + com.getProperty("SUITABLE_2050_ID"));
                    writer.println("Native hspec id " + com.getProperty("NATIVE_ID"));
                    writer.println("Native 2050 hspec id " + com.getProperty("NATIVE_2050_ID"));
                    writer.flush();
                }
                catch (Exception e) {
                    logger.error("Unexpected Error ", (Throwable)e);
                    resp.setStatus(500);
                    if (it == null) break block13;
                    try {
                        it.close();
                    }
                    catch (Exception e2) {
                        logger.error("Unable to close iterator ", (Throwable)e2);
                    }
                }
            }
            finally {
                if (it != null) {
                    try {
                        it.close();
                    }
                    catch (Exception e) {
                        logger.error("Unable to close iterator ", (Throwable)e);
                    }
                }
            }
        }
    }
}

