package org.gcube.application.aquamaps.images;

import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;
import org.gcube.application.aquamaps.images.exceptions.ImageNotFoundException;
import org.gcube.application.aquamaps.images.exceptions.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pics extends HttpServlet {

	private static final Logger logger = LoggerFactory.getLogger(Pics.class);
	private static Common common=Common.get();
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 6192206746569409892L;

	
	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		InputStream is=null;
		try{
			
			String scientificName=req.getParameter(Common.SPECIES_PARAM);
			if(scientificName==null) throw new InvalidRequestException();
			scientificName=scientificName.toLowerCase();

			resp.setContentType(Common.IMAGE_JPEG);
			
			is=common.getSpeciesPicture(scientificName);
			
			IOUtils.copy(is, resp.getOutputStream());
		}catch(IOException e){
			is=common.getImageNotFound();
			IOUtils.copy(is, resp.getOutputStream());
		}catch(ImageNotFoundException e){
			is=common.getImageNotFound();
			IOUtils.copy(is, resp.getOutputStream());
		}catch(InvalidRequestException e){
			resp.setStatus(HttpServletResponse.SC_BAD_REQUEST);
		}catch(Exception e){
			logger.error("Unexpected error ",e);
			resp.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
		}finally{
			if(is!=null) IOUtils.closeQuietly(is);
			try{
				IOUtils.closeQuietly(resp.getOutputStream());
			}catch (Throwable t){
				logger.error("",t);
			}
		}
	}
	
}
