package org.gcube.application.aquamaps.images;

import static org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin.dataManagement;
import static org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin.maps;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.Properties;

import net.sf.csv4j.CSVReaderProcessor;

import org.gcube.application.aquamaps.aquamapsservice.client.proxies.DataManagement;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeciesInfoImportThread extends Thread {

	private static final Logger logger = LoggerFactory.getLogger(SpeciesInfoImportThread.class);


	private Properties props;


	public SpeciesInfoImportThread(Properties props) {
		this.props=props;
	}


	@Override
	public void run() {
		while(true){
			Hashtable<String,String> configuration=(Hashtable<String, String>) props.clone();
			try{
				String scope=configuration.get(Common.SCOPE_PROP);
				ScopeProvider.instance.set(scope);
				
				logger.trace("Fetching info in scope "+scope);
				org.gcube.application.aquamaps.aquamapsservice.client.proxies.Maps maps=maps().build();
				DataManagement dmService=dataManagement().build();
				
				int hspenID=0;
				for(Field f:dmService.getDefaultSources()){
					if(f.getName().equals(ResourceType.HSPEN+"")) {
						hspenID=f.getValueAsInteger();
						logger.debug("Using hspen id "+hspenID);
						break;
					}
				}
				
				File toRead=maps.getCSVSpecies(hspenID, null, null);
				
				CSVReaderProcessor processor=new CSVReaderProcessor();

				processor.setDelimiter(',');
				processor.setHasHeader(true);

				SpeciesCSVLineProcessor lineProcessor=new SpeciesCSVLineProcessor(
						scope,
						Integer.parseInt(configuration.get(Common.SUITABLE_PROP)),
						Integer.parseInt(configuration.get(Common.SUITABLE_2050_PROP)),
						Integer.parseInt(configuration.get(Common.NATIVE_PROP)),
						Integer.parseInt(configuration.get(Common.NATIVE_2050_PROP)));

				Reader reader= new InputStreamReader(new FileInputStream(toRead), Charset.defaultCharset());

				processor.processStream(reader , lineProcessor);
				
				logger.trace("Fetched "+lineProcessor.getCount());
				
				Common.get().setLastCompletedUpdate(System.currentTimeMillis());
				Common.get().setLastConfiguration(configuration);
			}catch(Throwable e){
				logger.error("Unexpected Error ", e);
			}finally{
				try{
					long minutes=Long.parseLong(configuration.get(Common.FETCH_ROUTINE_INTERVAL_MINUTES));
					logger.trace("Going to execute again in "+minutes+" min");
					sleep(minutes*60*1000);
				}catch(InterruptedException e){

				}catch(Throwable t){
					logger.error("Unexpected exception ",t);
				}
			}
		}
	}

}
