/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.images;

import java.sql.SQLException;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.AquaMap;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ObjectType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.PublisherInterface;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.PublisherServiceCall;
import org.gcube.application.aquamaps.images.Common;
import org.gcube.application.aquamaps.images.SpeciesInfoImportThread;
import org.gcube.application.aquamaps.images.model.SpeciesInfo;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpeciesCSVLineProcessor
implements CSVLineProcessor {
    private static final GCUBELog logger = new GCUBELog(SpeciesInfoImportThread.class);
    long count = 0L;
    int genusIndex = 0;
    int speciesIndex = 0;
    int picnameIndex = 0;
    int suitableID;
    int suitable2050ID;
    int nativeID;
    int native2050ID;
    PublisherInterface pub;

    public SpeciesCSVLineProcessor(GCUBEScope scope, int suitableID, int suitable2050ID, int nativeID, int native2050ID) throws Exception {
        this.suitableID = suitableID;
        this.suitable2050ID = suitable2050ID;
        this.nativeID = nativeID;
        this.native2050ID = native2050ID;
        this.pub = PublisherServiceCall.getCall((GCUBEScope)scope, (String)"", (boolean)true);
    }

    public boolean continueProcessing() {
        return true;
    }

    public void processDataLine(int arg0, List<String> arg1) {
        try {
            String picname = arg1.get(this.picnameIndex);
            String species = arg1.get(this.speciesIndex);
            String genus = arg1.get(this.genusIndex);
            SpeciesInfo info = new SpeciesInfo();
            info.setScientificName(new String(genus + species).toLowerCase());
            info.setPic(picname);
            try {
                for (AquaMap map : this.pub.getMapsBySpecies(new String[]{genus + "_" + species}, false, false, null)) {
                    if (!map.getMapType().equals((Object)ObjectType.SpeciesDistribution)) continue;
                    if (map.getResource().getSearchId() == this.suitableID) {
                        info.setSuitableURI(SpeciesCSVLineProcessor.getEarthURI((List)map.getFiles()));
                        continue;
                    }
                    if (map.getResource().getSearchId() == this.suitable2050ID) {
                        info.setSuitable2050URI(SpeciesCSVLineProcessor.getEarthURI((List)map.getFiles()));
                        continue;
                    }
                    if (map.getResource().getSearchId() == this.nativeID) {
                        info.setNativeURI(SpeciesCSVLineProcessor.getEarthURI((List)map.getFiles()));
                        continue;
                    }
                    if (map.getResource().getSearchId() != this.native2050ID) continue;
                    info.setNative2050URI(SpeciesCSVLineProcessor.getEarthURI((List)map.getFiles()));
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to contact publisher " + e.getMessage()));
                logger.debug((Object)"Exception was ", (Throwable)e);
            }
            Common.get().getDao().createOrUpdate((Object)info);
            ++this.count;
        }
        catch (SQLException e) {
            logger.error((Object)("Unable to insert / update " + e.getMessage()));
            logger.debug((Object)"Exception was ", (Throwable)e);
        }
    }

    public void processHeaderLine(int arg0, List<String> arg1) {
        for (int i = 0; i < arg1.size(); ++i) {
            String column = arg1.get(i);
            if (column.equals("genus")) {
                this.genusIndex = i;
                continue;
            }
            if (column.equals("species")) {
                this.speciesIndex = i;
                continue;
            }
            if (!column.equals("picname")) continue;
            this.picnameIndex = i;
        }
    }

    public long getCount() {
        return this.count;
    }

    private static final String getEarthURI(List<File> files) {
        for (File f : files) {
            if (!f.getName().equals("Earth")) continue;
            return f.getUuri();
        }
        return "";
    }
}

