package org.gcube.application.aquamaps.images;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Properties;

import net.sf.csv4j.CSVReaderProcessor;

import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.AquaMapsServiceCall;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.AquaMapsServiceInterface;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.DataManagementCall;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.DataManagementInterface;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;

public class SpeciesInfoImportThread extends Thread {

	private static final GCUBELog logger=new GCUBELog(SpeciesInfoImportThread.class);


	private Properties props;


	public SpeciesInfoImportThread(Properties props) {
		this.props=props;
	}


	@Override
	public void run() {
		while(true){
			try{
				GCUBEScope scope=GCUBEScope.getScope(props.getProperty(Common.SCOPE_PROP));
				logger.trace("Fetching info in scope "+scope);
				AquaMapsServiceInterface as=AquaMapsServiceCall.getCall(scope, "", true);
				DataManagementInterface dmService=DataManagementCall.getCall(scope, "", true);
				
				int hspenID=0;
				for(Field f:dmService.getDefaultSources()){
					if(f.getName().equals(ResourceType.HSPEN+"")) {
						hspenID=f.getValueAsInteger();
						logger.debug("Using hspen id "+hspenID);
						break;
					}
				}
				
				File toRead=as.getCSVSpecies(hspenID, null, null);
				
				CSVReaderProcessor processor=new CSVReaderProcessor();

				processor.setDelimiter(',');
				processor.setHasHeader(true);

				SpeciesCSVLineProcessor lineProcessor=new SpeciesCSVLineProcessor(
						scope,
						Integer.parseInt(props.getProperty(Common.SUITABLE_PROP)),
						Integer.parseInt(props.getProperty(Common.SUITABLE_2050_PROP)),
						Integer.parseInt(props.getProperty(Common.NATIVE_PROP)),
						Integer.parseInt(props.getProperty(Common.NATIVE_2050_PROP)));

				Reader reader= new InputStreamReader(new FileInputStream(toRead), Charset.defaultCharset());

				processor.processStream(reader , lineProcessor);
				
				logger.trace("Fetched "+lineProcessor.getCount());
				
				Common.get().setLastCompletedUpdate(System.currentTimeMillis());

			}catch(Throwable e){
				logger.error("Unexpected Error ", e);
			}finally{
				try{
					long minutes=Long.parseLong(props.getProperty(Common.FETCH_ROUTINE_INTERVAL_MINUTES));
					logger.trace("Going to execute again in "+minutes+" min");
					sleep(minutes*60*1000);
				}catch(InterruptedException e){

				}catch(Throwable t){
					logger.fatal("Unexpected exception ",t);
				}
			}
		}
	}

}
