package org.gcube.application.aquamaps.images.model;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;

@DatabaseTable
public class SpeciesInfo {

	@DatabaseField(id=true)
	private String scientificName;
	@DatabaseField
	private String suitableURI;
	@DatabaseField
	private String nativeURI;
	@DatabaseField
	private String suitable2050URI;
	@DatabaseField
	private String native2050URI;
	@DatabaseField
	private String pic;
	
	public SpeciesInfo() {
		// TODO Auto-generated constructor stub
	}
	
	
	public SpeciesInfo(String scientificName, String suitableURI,
			String nativeURI, String suitable2050uri, String native2050uri,
			String pic) {
		super();
		this.scientificName = scientificName;
		this.suitableURI = suitableURI;
		this.nativeURI = nativeURI;
		suitable2050URI = suitable2050uri;
		native2050URI = native2050uri;
		this.pic = pic;
	}



	/**
	 * @return the scientificName
	 */
	public String getScientificName() {
		return scientificName;
	}
	/**
	 * @param scientificName the scientificName to set
	 */
	public void setScientificName(String scientificName) {
		this.scientificName = scientificName;
	}
	/**
	 * @return the suitableURI
	 */
	public String getSuitableURI() {
		return suitableURI;
	}
	/**
	 * @param suitableURI the suitableURI to set
	 */
	public void setSuitableURI(String suitableURI) {
		this.suitableURI = suitableURI;
	}
	/**
	 * @return the nativeURI
	 */
	public String getNativeURI() {
		return nativeURI;
	}
	/**
	 * @param nativeURI the nativeURI to set
	 */
	public void setNativeURI(String nativeURI) {
		this.nativeURI = nativeURI;
	}
	/**
	 * @return the suitable2050URI
	 */
	public String getSuitable2050URI() {
		return suitable2050URI;
	}
	/**
	 * @param suitable2050uri the suitable2050URI to set
	 */
	public void setSuitable2050URI(String suitable2050uri) {
		suitable2050URI = suitable2050uri;
	}
	/**
	 * @return the native2050URI
	 */
	public String getNative2050URI() {
		return native2050URI;
	}
	/**
	 * @param native2050uri the native2050URI to set
	 */
	public void setNative2050URI(String native2050uri) {
		native2050URI = native2050uri;
	}
	/**
	 * @return the pic
	 */
	public String getPic() {
		return pic;
	}
	/**
	 * @param pic the pic to set
	 */
	public void setPic(String pic) {
		this.pic = pic;
	}


	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((scientificName == null) ? 0 : scientificName.hashCode());
		return result;
	}


	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SpeciesInfo other = (SpeciesInfo) obj;
		if (scientificName == null) {
			if (other.scientificName != null)
				return false;
		} else if (!scientificName.equals(other.scientificName))
			return false;
		return true;
	}


	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("SpeciesInfo [scientificName=");
		builder.append(scientificName);
		builder.append(", suitableURI=");
		builder.append(suitableURI);
		builder.append(", nativeURI=");
		builder.append(nativeURI);
		builder.append(", suitable2050URI=");
		builder.append(suitable2050URI);
		builder.append(", native2050URI=");
		builder.append(native2050URI);
		builder.append(", pic=");
		builder.append(pic);
		builder.append("]");
		return builder.toString();
	}
	
	
	
	
}
