/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.rest.health;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckResponseSerializer
extends JsonSerializer<HealthCheckResponse> {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckResponseSerializer.class);

    public void serialize(HealthCheckResponse response, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        if (response.getName() != null) {
            gen.writeStringField("name", response.getName());
        }
        if (response.getState() != null) {
            gen.writeStringField("state", response.getState().toString());
        }
        response.getData().ifPresent(data -> {
            try {
                gen.writeObjectFieldStart("data");
                for (Map.Entry entry : data.entrySet()) {
                    gen.writeObjectField((String)entry.getKey(), entry.getValue());
                }
                gen.writeEndObject();
            }
            catch (IOException e) {
                log.warn("Error on serializing the data field", (Throwable)e);
            }
        });
        gen.writeEndObject();
    }
}

