/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.postgis;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.gcube.application.geoportal.common.model.rest.DatabaseConnection;
import org.gcube.application.geoportal.service.engine.ImplementationProvider;
import org.gcube.application.geoportal.service.engine.postgis.PostgisDBManagerI;
import org.gcube.application.geoportal.service.model.internal.db.PostgisTable;
import org.gcube.application.geoportal.service.model.internal.faults.ConfigurationException;
import org.gcube.application.geoportal.service.model.internal.faults.DataParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PostgisDBManager
implements PostgisDBManagerI {
    private static final Logger log = LoggerFactory.getLogger(PostgisDBManager.class);
    private Connection conn = null;
    private DatabaseConnection config;

    public static PostgisDBManagerI get() throws SQLException, ConfigurationException {
        return PostgisDBManager.get((boolean)false);
    }

    private static PostgisDBManagerI get(boolean autocommit) throws SQLException, ConfigurationException {
        DatabaseConnection config = ImplementationProvider.get().getIsProvider().getIS().queryForDB("postgis", "Concessioni");
        log.debug("Found configuration :  " + config);
        PostgisDBManager toReturn = new PostgisDBManager(config);
        toReturn.conn.setAutoCommit(autocommit);
        return toReturn;
    }

    private PostgisDBManager(DatabaseConnection config) throws SQLException {
        this.config = config;
        log.info("Opening connection to {}", (Object)config);
        this.conn = DriverManager.getConnection(config.getUrl(), config.getUser(), config.getPwd());
        this.conn.setAutoCommit(false);
    }

    public void create(PostgisTable toCreate) throws SQLException {
        String createStmt = toCreate.getCreateStatement();
        log.debug("Executing create : " + createStmt);
        this.conn.createStatement().executeUpdate(createStmt);
    }

    public void commit() throws SQLException {
        this.conn.commit();
    }

    public PostgisTable.POINT evaluateCentroid(PostgisTable table) throws SQLException, DataParsingException {
        ResultSet rs = this.conn.createStatement().executeQuery("Select ST_AsText(ST_Centroid(ST_Collect(" + table.getGeometryColumn() + "))) as centroid from " + table.getTablename());
        if (rs.next()) {
            return PostgisTable.POINT.parsePOINT((String)rs.getString("centroid"));
        }
        throw new SQLException("No extent returned");
    }

    public PreparedStatement prepareInsertStatement(PostgisTable target, boolean createTable, boolean geometryAsText) throws SQLException {
        if (createTable) {
            this.create(target);
        }
        String insertStmt = target.getInsertionStatement(geometryAsText);
        log.debug("Preparing insert statement : " + insertStmt);
        return this.conn.prepareStatement(insertStmt);
    }

    public int deleteByFieldValue(PostgisTable target, PostgisTable.Field field, Object value) throws SQLException {
        String query = target.getDeleteByFieldStatement(field);
        log.debug("Preparing DELETE SQL {} with field {} = {} ", new Object[]{query, field, value});
        PreparedStatement stmt = this.conn.prepareStatement(query);
        target.setObjectInPreparedStatement(field, value, stmt, 1);
        int result = stmt.executeUpdate();
        log.debug("DELETED {} rows ", (Object)result);
        return result;
    }

    public DatabaseConnection getConnectionDescriptor() {
        return this.config;
    }

    public void deleteTable(String tableName) throws SQLException {
        this.conn.createStatement().executeUpdate("DROP TABLE " + tableName);
    }

    public void truncate(String tableName) throws SQLException {
        this.conn.createStatement().executeUpdate("TRUNCATE Table " + tableName);
    }

    public ResultSet queryAll(PostgisTable table) throws SQLException {
        return this.conn.createStatement().executeQuery("Select * from " + table.getTablename());
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

