package org.gcube.application.geoportal.service.engine.mongo;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.bson.Document;
import org.gcube.application.cms.plugins.faults.StepException;
import org.gcube.application.geoportal.common.model.rest.QueryRequest;
import org.gcube.application.geoportal.service.model.internal.faults.DeletionException;

import java.io.IOException;

public interface MongoManagerI<T> {


    // create

    public T registerNew(Document toRegister) throws IOException, StepException;

    // update
    public T update(String id,T toSet) throws IOException, StepException;

    // delete

    public void delete(String id,boolean force) throws DeletionException;

    // get By ID

    public T getByID(String id) throws IOException;

    // query

    public Iterable<Document> query(QueryRequest request);
    public Iterable<T> filter(QueryRequest request);

    // materialize

    public T materialize(String id);

    // dematerialize

    public T dematerialize(String id);
    // index

    public T index(String id);

    // deIndex
    public T deIndex(String id);

    public T performStep(String id, String step, Document options);
}
