/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.rest;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.bson.Document;
import org.gcube.application.geoportal.common.model.configuration.Configuration;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.document.access.Access;
import org.gcube.application.geoportal.common.model.document.relationships.Relationship;
import org.gcube.application.geoportal.common.model.document.relationships.RelationshipNavigationObject;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.rest.RegisterFileSetRequest;
import org.gcube.application.geoportal.common.model.rest.StepExecutionRequest;
import org.gcube.application.geoportal.service.engine.mongo.ProfiledMongoManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="projects/{usecase_id}")
public class ProfiledDocuments {
    private static final Logger log = LoggerFactory.getLogger(ProfiledDocuments.class);
    private ProfiledMongoManager manager;

    public ProfiledDocuments(@PathParam(value="usecase_id") String profileID) throws ConfigurationException {
        log.info("Accessing profile " + profileID);
        this.manager = (ProfiledMongoManager)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @GET
    @Path(value="configuration")
    @Produces(value={"application/json"})
    public Configuration getConfiguration(@PathParam(value="usecase_id") String profileID) {
        return (Configuration)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Project createNew(Document d) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @PUT
    @Path(value="{project_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Project update(@PathParam(value="project_id") String documentId, Document d) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="{project_id}")
    public Boolean delete(@PathParam(value="project_id") String id, @DefaultValue(value="false") @QueryParam(value="force") Boolean force) {
        return (Boolean)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/registerFiles/{project_id}")
    public Project registerFileSet(@PathParam(value="project_id") String id, RegisterFileSetRequest request) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/deleteFiles/{project_id}")
    public Project deleteFileSet(@PathParam(value="project_id") String id, @DefaultValue(value="false") @QueryParam(value="force") Boolean force, String path) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/step/{project_id}")
    public Project performStep(@PathParam(value="project_id") String id, StepExecutionRequest request) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/forceUnlock/{project_id}")
    public Project forceUnlock(@PathParam(value="project_id") String id) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/setAccess/{project_id}")
    public Project setAccessPolicy(@PathParam(value="project_id") String id, Access toSet) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @GET
    @Produces(value={"application/json"})
    public Iterable<?> list() {
        return (Iterable)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{project_id}")
    public Project getById(@PathParam(value="project_id") String id) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/search")
    public String search(String filter) {
        return (String)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/query")
    public Iterable<?> query(String queryString) {
        return (Iterable)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{relationship}/{project_id}/{relationship_id}")
    public String getRelationshipChain(@PathParam(value="project_id") String id, @PathParam(value="relationship_id") String relationshipId, @DefaultValue(value="false") @QueryParam(value="deep") Boolean deep) {
        return (String)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="{relationship}/{project_id}/{relationship_id}")
    public Project setRelation(@PathParam(value="project_id") String id, @PathParam(value="relationship_id") String relationshipId, @QueryParam(value="target_ucd") String targetId, @QueryParam(value="target_id") String targetUCD) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="{relationship}/{project_id}/{relationship_id}")
    public Project deleteRelation(@PathParam(value="project_id") String id, @PathParam(value="relationship_id") String relationshipId, @QueryParam(value="target_ucd") String targetId, @QueryParam(value="target_id") String targetUCD) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    private static List<RelationshipNavigationObject> getLinked(Project current, String relationName, Boolean recurse) throws Exception {
        log.debug("Getting Relationships Lists for {} [rel : {}, recurse {}]", new Object[]{current.getId(), relationName, recurse});
        ArrayList<RelationshipNavigationObject> toReturn = new ArrayList<RelationshipNavigationObject>();
        List existing = current.getRelationshipsByName(relationName);
        for (Relationship relationship : existing) {
            try {
                log.trace("Navigating from  {} : {} to[rel {} ] {} : {}", new Object[]{relationship.getTargetUCD(), relationship.getTargetID(), relationship.getRelationshipName(), current.getProfileID(), current.getId()});
                RelationshipNavigationObject linkedProject = new RelationshipNavigationObject();
                linkedProject.setTarget(new ProfiledMongoManager(relationship.getTargetUCD()).getByID(relationship.getTargetID()));
                if (recurse.booleanValue()) {
                    linkedProject.setChildren(ProfiledDocuments.getLinked((Project)linkedProject.getTarget(), (String)relationName, (Boolean)recurse));
                }
                toReturn.add(linkedProject);
            }
            catch (Exception e) {
                log.warn("Unable to navigate from  {} : {} to[rel {} ] {} : {}", new Object[]{relationship.getTargetUCD(), relationship.getTargetID(), relationship.getRelationshipName(), current.getProfileID(), current.getId(), e});
            }
        }
        return toReturn;
    }

    static /* synthetic */ ProfiledMongoManager access$000(ProfiledDocuments x0) {
        return x0.manager;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ List access$200(Project x0, String x1, Boolean x2) throws Exception {
        return ProfiledDocuments.getLinked((Project)x0, (String)x1, (Boolean)x2);
    }
}

