/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.rest;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.application.cms.plugins.faults.InsufficientPrivileges;
import org.gcube.application.cms.plugins.faults.UnrecognizedStepException;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.service.model.internal.faults.InvalidLockException;
import org.gcube.application.geoportal.service.model.internal.faults.InvalidUserRoleException;
import org.gcube.application.geoportal.service.model.internal.faults.ProjectLockedException;
import org.gcube.application.geoportal.service.model.internal.faults.ProjectNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GuardedMethod<T> {
    private static final Logger log = LoggerFactory.getLogger(GuardedMethod.class);
    private static List<Runnable> preoperations = new ArrayList();
    private T result = null;

    public static void addPreoperation(Runnable preoperation) {
        preoperations.add(preoperation);
    }

    public GuardedMethod<T> execute() throws WebApplicationException {
        try {
            if (!preoperations.isEmpty()) {
                log.trace("Running preops (size : {} )", (Object)preoperations.size());
                for (Runnable r : preoperations) {
                    r.run();
                }
            }
            log.trace("Executing actual method..");
            this.result = this.run();
            return this;
        }
        catch (InvalidUserRoleException e) {
            log.error("Returning exception ", (Throwable)e);
            throw new WebApplicationException("Invalid Step ID ", (Throwable)e, Response.Status.FORBIDDEN);
        }
        catch (UnrecognizedStepException e) {
            log.error("Returning exception ", (Throwable)e);
            throw new WebApplicationException("Invalid Step ID ", (Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (ConfigurationException e) {
            log.error("Returning exception ", (Throwable)e);
            throw new WebApplicationException("Environment is not properly configured", (Throwable)e, Response.Status.EXPECTATION_FAILED);
        }
        catch (InsufficientPrivileges e) {
            log.error("Returning exception ", (Throwable)e);
            throw new WebApplicationException("User has insufficient privileges for requested action", (Throwable)e, Response.Status.FORBIDDEN);
        }
        catch (WebApplicationException e) {
            log.error("Throwing Web Application Exception ", (Throwable)e);
            throw e;
        }
        catch (ProjectNotFoundException e) {
            log.error("Returning exception ", (Throwable)e);
            throw new WebApplicationException("Project not found", (Throwable)e, Response.Status.NOT_FOUND);
        }
        catch (ProjectLockedException e) {
            log.error("Returning exception ", (Throwable)e);
            throw new WebApplicationException("Project is currently locked", (Throwable)e, Response.Status.PRECONDITION_FAILED);
        }
        catch (InvalidLockException e) {
            log.error("Lock exception ", (Throwable)e);
            throw new WebApplicationException("Conflicts found in locks", (Throwable)e, Response.Status.CONFLICT);
        }
        catch (Throwable t) {
            log.error("Unexpected error ", t);
            throw new WebApplicationException("Unexpected internal error", t, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public T getResult() {
        return (T)this.result;
    }

    protected abstract T run() throws Exception, WebApplicationException;
}

