package org.gcube.application.geoportal.service.engine.providers;

import org.gcube.application.cms.caches.AbstractScopedMap;
import org.gcube.application.geoportal.service.engine.postgis.PostgisDBManager;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;

import java.sql.SQLException;

public class PostgisConnectionProvider extends AbstractScopedMap<PostgisDBManager> {


    public PostgisConnectionProvider() {
        super("Postgis connection descriptor cache");
    }

    @Override
    protected PostgisDBManager retrieveObject(String context) throws ConfigurationException {
        try {
            return PostgisDBManager.get();
        } catch (SQLException throwables) {
            throw new ConfigurationException(throwables);
        }
    }

    @Override
    protected void dispose(PostgisDBManager toDispose) {
//        toDispose.close();
    }

    @Override
    public void init() {
//
    }
}
