/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.providers.ucd;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.gcube.application.cms.caches.AbstractScopedMap;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.UseCaseDescriptor;
import org.gcube.application.geoportal.common.utils.Files;
import org.gcube.application.geoportal.service.engine.providers.ucd.ProfileMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFolderProfileMapCache
extends AbstractScopedMap<ProfileMap> {
    private static final Logger log = LoggerFactory.getLogger(LocalFolderProfileMapCache.class);
    String folderPath = null;

    public LocalFolderProfileMapCache(String folderPath) {
        super("Local Profiles CACHE");
        this.folderPath = folderPath;
    }

    public void init() {
    }

    protected void dispose(ProfileMap toDispose) {
    }

    protected ProfileMap retrieveObject(String context) throws ConfigurationException {
        ProfileMap toReturn = new ProfileMap();
        try {
            log.debug("Loading from {} ", (Object)this.folderPath);
            File baseFolder = new File(this.folderPath);
            for (File file : baseFolder.listFiles(pathname -> pathname.getName().endsWith(".json"))) {
                try {
                    String jsonString = Files.readFileAsString((String)file.getAbsolutePath(), (Charset)Charset.defaultCharset());
                    log.trace("JSON IS {}", (Object)jsonString);
                    UseCaseDescriptor p = (UseCaseDescriptor)Serialization.read((String)jsonString, UseCaseDescriptor.class);
                    toReturn.put((Object)p.getId(), (Object)p);
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return toReturn;
    }
}

