package org.gcube.application.geoportal.service.engine;

//import org.gcube.application.geoportal.managers.AbstractRecordManager;
//import org.gcube.application.geoportal.managers.EMFProvider;

import lombok.Getter;
import lombok.Setter;
import lombok.Synchronized;
import org.gcube.application.geoportal.service.engine.providers.*;

public class ImplementationProvider {

	private static ImplementationProvider instance=null;
	
	@Synchronized
	public static ImplementationProvider get() {
		if(instance==null) {
			instance=new ImplementationProvider();
		}
		return instance;
	}
	

	@Getter
	@Setter
	private MongoClientProvider mongoClientProvider=new MongoClientProvider();
	
	
	@Getter
	@Setter
	private StorageClientProvider storageProvider=new StorageClientProvider();
	
	@Getter
	@Setter
	private PostgisConnectionProvider dbProvider=new PostgisConnectionProvider();

	@Getter
	@Setter
	private ISProvider isProvider=new ISProvider();

	@Getter
	@Setter
	private ProfileMapCache profiles=new ProfileMapCache();
	
	
	@Getter
	@Setter
	private StorageHubProvider sHubProvider=new StorageHubProvider();
	
	public void shutdown() {
		// Stop JPA
//		AbstractRecordManager.shutdown();

		mongoClientProvider.shutdown();
	}
	
	public void startup() {
//		AbstractRecordManager.setDefaultProvider(emfProvider);

		mongoClientProvider.init();
	}
}
