/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.providers;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import org.gcube.application.geoportal.service.engine.ImplementationProvider;
import org.gcube.application.geoportal.service.engine.providers.AbstractScopedMap;
import org.gcube.application.geoportal.service.model.internal.db.MongoConnection;
import org.gcube.application.geoportal.service.model.internal.faults.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoClientProvider
extends AbstractScopedMap<MongoClient> {
    private static final Logger log = LoggerFactory.getLogger(MongoClientProvider.class);

    public MongoClientProvider() {
        super("MongoClient cache");
    }

    protected MongoClient retrieveObject() throws ConfigurationException {
        MongoConnection conn = ImplementationProvider.get().getIsProvider().getIS().queryForMongoDB("mongodb", "internal-db");
        log.debug("Connecting to " + conn);
        MongoCredential credential = MongoCredential.createCredential((String)conn.getUser(), (String)conn.getDatabase(), (char[])conn.getPassword().toCharArray());
        MongoClientOptions options = MongoClientOptions.builder().threadsAllowedToBlockForConnectionMultiplier(10).connectionsPerHost(20).maxConnectionIdleTime(10000).applicationName("geoportal-service").sslEnabled(true).connectTimeout(30000).build();
        return new MongoClient(new ServerAddress((String)conn.getHosts().get(0), conn.getPort()), credential, options);
    }

    protected void dispose(MongoClient toDispose) {
        toDispose.close();
    }

    public void init() {
    }
}

