package org.gcube.application.geoportal.service.engine.providers;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import lombok.extern.slf4j.Slf4j;
import org.gcube.application.geoportal.service.ServiceConstants;
import org.gcube.application.geoportal.service.engine.ImplementationProvider;
import org.gcube.application.geoportal.service.model.internal.db.MongoConnection;
import org.gcube.application.geoportal.service.model.internal.faults.ConfigurationException;
import org.gcube.application.geoportal.service.utils.ISUtils;

@Slf4j
public class MongoClientProvider extends AbstractScopedMap<MongoClient>{

	public MongoClientProvider() {
		super("MongoClient cache");
		//NO TTL = Map by context
//		setTTL(Duration.of(10, ChronoUnit.MINUTES));
	}

	@Override
	protected MongoClient retrieveObject() throws ConfigurationException {
		MongoConnection conn=ImplementationProvider.get().
				getIsProvider().getIS().queryForMongoDB(
						ServiceConstants.MONGO_SE_PLATFORM, ServiceConstants.MONGO_SE_GNA_FLAG);

		log.debug("Connecting to "+conn);
		
		MongoCredential credential = MongoCredential.createCredential(conn.getUser(), conn.getDatabase(), 
				conn.getPassword().toCharArray());

		
		
		 MongoClientOptions options = MongoClientOptions.builder().
				 threadsAllowedToBlockForConnectionMultiplier(10).
				 connectionsPerHost(20).
				 maxConnectionIdleTime(10000).
				 applicationName("geoportal-service").
				 sslEnabled(true).
				 build();

		 return new MongoClient(new ServerAddress(conn.getHosts().get(0),conn.getPort()),
		                                           credential,
		                                           options);
	}
	
	@Override
	protected void dispose(MongoClient toDispose) {
		toDispose.close();
	}
	
	@Override
	public void init() {
		// TODO Auto-generated method stub
	}
}
