package org.gcube.application.geoportal.service.engine.postgis;

import org.gcube.application.geoportal.common.model.rest.DatabaseConnection;
import org.gcube.application.geoportal.service.model.internal.db.PostgisTable;
import org.gcube.application.geoportal.service.model.internal.faults.DataParsingException;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public interface PostgisDBManagerI {

    void commit() throws SQLException;





    PreparedStatement prepareInsertStatement(PostgisTable target, boolean createTable, boolean geometryAsText)
            throws SQLException;


    void deleteTable(String tableName) throws SQLException;

    void truncate(String tableName) throws SQLException;

    void create(PostgisTable toCreate) throws SQLException;

    PostgisTable.POINT evaluateCentroid(PostgisTable table) throws SQLException, DataParsingException;


    ResultSet queryAll(PostgisTable table) throws SQLException;

    int deleteByFieldValue(PostgisTable target, PostgisTable.Field field, Object value) throws SQLException;

    DatabaseConnection getConnectionDescriptor();
}
