/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.mongo;

import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.gcube.application.geoportal.model.fault.ConfigurationException;
import org.gcube.application.geoportal.service.engine.ImplementationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MongoManager {
    private static final Logger log = LoggerFactory.getLogger(MongoManager.class);
    protected MongoClient client = (MongoClient)ImplementationProvider.get().getMongoClientProvider().getObject();
    protected static final String ID = "_id";

    protected static final ObjectId asId(String id) {
        return new ObjectId(id);
    }

    protected static final String asString(ObjectId id) {
        return id.toHexString();
    }

    protected static final String asString(Document d) {
        return d.toJson();
    }

    protected static final Document asDoc(String json) {
        return Document.parse((String)json);
    }

    public MongoManager() throws ConfigurationException {
        log.info("Got Mongo Client at " + this.client.getConnectPoint());
    }

    protected abstract MongoDatabase getDatabase();

    protected ObjectId insert(Document proj, String collectionName) {
        MongoDatabase database = this.getDatabase();
        MongoCollection collection = database.getCollection(collectionName);
        ObjectId id = proj.getObjectId((Object)ID);
        if (id == null) {
            proj.append(ID, (Object)new ObjectId());
            id = proj.getObjectId((Object)ID);
        }
        collection.insertOne((Object)Document.parse((String)proj.toJson()));
        return id;
    }

    public void delete(ObjectId id, String collectionName) {
        MongoDatabase database = this.getDatabase();
        MongoCollection collection = database.getCollection(collectionName);
        collection.deleteOne(Filters.eq((String)ID, (Object)id));
    }

    public Document getById(ObjectId id, String collectionName) {
        MongoDatabase database = this.getDatabase();
        MongoCollection coll = database.getCollection(collectionName);
        return (Document)coll.find((Bson)new Document(ID, (Object)id)).first();
    }

    public FindIterable<Document> iterate(Document filter, String collectionName) {
        MongoDatabase database = this.getDatabase();
        MongoCollection coll = database.getCollection(collectionName);
        if (filter == null) {
            return coll.find();
        }
        return coll.find((Bson)filter);
    }

    public <T> FindIterable<T> iterateForClass(Document filter, String collectionName, Class<T> clazz) {
        MongoDatabase database = this.getDatabase();
        MongoCollection coll = database.getCollection(collectionName);
        if (filter == null) {
            return coll.find(clazz);
        }
        return coll.find((Bson)filter, clazz);
    }

    public Document replace(Document toUpdate, String collectionName) {
        MongoDatabase database = this.getDatabase();
        MongoCollection coll = database.getCollection(collectionName);
        return (Document)coll.findOneAndReplace(Filters.eq((String)ID, (Object)toUpdate.getObjectId((Object)ID)), (Object)toUpdate, new FindOneAndReplaceOptions().returnDocument(ReturnDocument.AFTER));
    }

    public Document update(ObjectId id, Document updateSet, String collectionName) {
        MongoDatabase database = this.getDatabase();
        MongoCollection coll = database.getCollection(collectionName);
        return (Document)coll.findOneAndUpdate(Filters.eq((String)ID, (Object)id), (Bson)updateSet, new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
    }
}

