/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.mongo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.gcube.application.geoportal.common.model.legacy.AssociatedContent;
import org.gcube.application.geoportal.common.model.legacy.Concessione;
import org.gcube.application.geoportal.common.model.legacy.GeoServerContent;
import org.gcube.application.geoportal.common.model.legacy.LayerConcessione;
import org.gcube.application.geoportal.common.model.legacy.OtherContent;
import org.gcube.application.geoportal.common.model.legacy.RelazioneScavo;
import org.gcube.application.geoportal.common.model.legacy.SDILayerDescriptor;
import org.gcube.application.geoportal.common.model.legacy.UploadedImage;
import org.gcube.application.geoportal.common.model.legacy.WorkspaceContent;
import org.gcube.application.geoportal.common.model.legacy.report.ValidationReport;
import org.gcube.application.geoportal.common.rest.TempFile;
import org.gcube.application.geoportal.common.utils.Files;
import org.gcube.application.geoportal.model.fault.ConfigurationException;
import org.gcube.application.geoportal.model.fault.PublishException;
import org.gcube.application.geoportal.service.engine.ImplementationProvider;
import org.gcube.application.geoportal.service.engine.SDIManager;
import org.gcube.application.geoportal.service.engine.StorageClientProvider;
import org.gcube.application.geoportal.service.engine.WorkspaceManager;
import org.gcube.application.geoportal.service.engine.mongo.MongoManager;
import org.gcube.application.geoportal.service.engine.mongo.PostgisIndex;
import org.gcube.application.geoportal.service.model.internal.faults.InvalidStateException;
import org.gcube.application.geoportal.service.model.internal.faults.SDIInteractionException;
import org.gcube.application.geoportal.service.utils.Serialization;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConcessioniMongoManager
extends MongoManager {
    private static final Logger log = LoggerFactory.getLogger(ConcessioniMongoManager.class);
    private final Object $lock = new Object[0];
    private static final String collectionName = "legacyConcessioni";
    private static final String DB_NAME = "gna_dev";
    private MongoDatabase db = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MongoDatabase getDatabase() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.db == null) {
                this.db = this.client.getDatabase("gna_dev");
            }
            return this.db;
        }
    }

    protected static Document asDocument(Concessione c) throws JsonProcessingException {
        Document toReturn = Document.parse((String)Serialization.write((Object)c));
        if (c.getMongo_id() != null && !c.getMongo_id().isEmpty()) {
            toReturn.append("_id", (Object)ConcessioniMongoManager.asId((String)c.getMongo_id()));
        }
        return toReturn;
    }

    protected static Concessione asConcessione(Document d) throws JsonProcessingException, IOException {
        return (Concessione)Serialization.read((String)d.toJson(), Concessione.class);
    }

    public Concessione registerNew(Concessione toRegister) throws IOException {
        log.trace("Registering {}\u00a0", (Object)toRegister);
        toRegister.setDefaults();
        ObjectId id = this.insert(ConcessioniMongoManager.asDocument((Concessione)toRegister), "legacyConcessioni");
        Concessione toReturn = ConcessioniMongoManager.asConcessione((Document)this.getById(id, "legacyConcessioni"));
        toReturn.setMongo_id(ConcessioniMongoManager.asString((ObjectId)id));
        return ConcessioniMongoManager.asConcessione((Document)this.replace(ConcessioniMongoManager.asDocument((Concessione)toReturn), "legacyConcessioni"));
    }

    public Concessione replace(Concessione toRegister) throws IOException {
        log.trace("Replacing {}\u00a0", (Object)toRegister);
        toRegister.setDefaults();
        return ConcessioniMongoManager.asConcessione((Document)this.replace(ConcessioniMongoManager.asDocument((Concessione)toRegister), "legacyConcessioni"));
    }

    public Concessione update(String id, String json) throws IOException {
        log.trace("Updating id {}\u00a0with {}\u00a0", (Object)id, (Object)json);
        Concessione toReturn = ConcessioniMongoManager.asConcessione((Document)this.update(ConcessioniMongoManager.asId((String)id), ConcessioniMongoManager.asDoc((String)json), "legacyConcessioni"));
        log.debug("Refreshing defaults..");
        toReturn.setDefaults();
        return ConcessioniMongoManager.asConcessione((Document)this.replace(ConcessioniMongoManager.asDocument((Concessione)toReturn), "legacyConcessioni"));
    }

    public List<Concessione> list() {
        ArrayList<Concessione> toReturn = new ArrayList<Concessione>();
        this.iterate(null, "legacyConcessioni").forEach((Consumer)new /* Unavailable Anonymous Inner Class!! */);
        return toReturn;
    }

    public Concessione getById(String id) throws JsonProcessingException, IOException {
        log.debug("Loading by ID " + id);
        return ConcessioniMongoManager.asConcessione((Document)this.getById(ConcessioniMongoManager.asId((String)id), "legacyConcessioni"));
    }

    public void deleteById(String id) {
        this.delete(ConcessioniMongoManager.asId((String)id), "legacyConcessioni");
    }

    public Concessione publish(String id) throws JsonProcessingException, IOException, InvalidStateException {
        Concessione toReturn = ConcessioniMongoManager.asConcessione((Document)this.getById(ConcessioniMongoManager.asId((String)id), "legacyConcessioni"));
        toReturn.setDefaults();
        toReturn.validate();
        toReturn = ConcessioniMongoManager.publish((Concessione)toReturn);
        toReturn = ConcessioniMongoManager.index((Concessione)toReturn);
        return ConcessioniMongoManager.asConcessione((Document)this.replace(ConcessioniMongoManager.asDocument((Concessione)toReturn), "legacyConcessioni"));
    }

    public Concessione persistContent(String id, String destinationPath, List<TempFile> files) throws Exception {
        log.info("Persisting {}\u00a0files for path {}\u00a0in concessione\u00a0", new Object[]{files.size(), destinationPath, id});
        try {
            Concessione c = this.getById(id);
            WorkspaceManager ws = new WorkspaceManager();
            FolderContainer baseFolder = null;
            if (c.getFolderId() == null) {
                String folderName = Files.fixFilename((String)("mConcessione_" + c.getNome() + "_" + Serialization.FULL_FORMATTER.format(LocalDateTime.now())));
                log.info("Creating folder {}\u00a0for Concessione ID {}\u00a0", (Object)folderName, (Object)id);
                FolderContainer folder = ws.createFolder(new WorkspaceManager.FolderOptions(folderName, "Base Folder for " + c.getNome(), null));
                c.setFolderId(folder.getId());
            }
            log.debug("Folder id is : " + c.getFolderId());
            baseFolder = ws.getFolderById(c.getFolderId());
            AssociatedContent section = c.getContentByPath(destinationPath);
            log.debug("Found section {}\u00a0for path {}", (Object)section, (Object)destinationPath);
            ConcessioniMongoManager.store((AssociatedContent)section, files, (WorkspaceManager)ws, (FolderContainer)baseFolder);
            log.debug("Updating dafults for {}\u00a0", (Object)c);
            c.setDefaults();
            return ConcessioniMongoManager.asConcessione((Document)this.replace(ConcessioniMongoManager.asDocument((Concessione)c), "legacyConcessioni"));
        }
        catch (Exception e) {
            throw new Exception("Unable to save file.", e);
        }
    }

    private static Concessione index(Concessione record) {
        log.info("Indexing {}\u00a0", (Object)record.getId());
        ValidationReport report = new ValidationReport("Index Report ");
        try {
            PostgisIndex index = new PostgisIndex(record);
            index.registerCentroid();
            report.addMessage(ValidationReport.ValidationStatus.PASSED, "Registered centroid");
        }
        catch (PublishException | SDIInteractionException e) {
            log.error("Unable to index {}\u00a0", (Object)record, (Object)e);
            report.addMessage(ValidationReport.ValidationStatus.WARNING, "Internal error while indexing.");
        }
        return record;
    }

    private static Concessione publish(Concessione conc) {
        log.debug("Publishing " + conc.getNome());
        ValidationReport report = new ValidationReport("Publish report");
        try {
            SDIManager sdiManager = new SDIManager();
            ArrayList<LayerConcessione> list = new ArrayList<LayerConcessione>();
            String workspace = sdiManager.createWorkspace("gna_conc_" + conc.getMongo_id());
            list.add(conc.getPosizionamentoScavo());
            list.addAll(conc.getPianteFineScavo());
            for (AssociatedContent associatedContent : list) {
                if (!(associatedContent instanceof LayerConcessione)) continue;
                try {
                    List p = associatedContent.getActualContent();
                    GeoServerContent geoserverPersisted = sdiManager.pushShapeLayerFileSet((SDILayerDescriptor)associatedContent, workspace, conc.getMongo_id());
                    p.add(geoserverPersisted);
                    associatedContent.setActualContent(p);
                }
                catch (SDIInteractionException e) {
                    log.warn("Unable to publish layers.", (Throwable)e);
                    report.addMessage(ValidationReport.ValidationStatus.WARNING, "Layer " + associatedContent.getTitolo() + " non pubblicato.");
                }
                report.addMessage(ValidationReport.ValidationStatus.PASSED, "Pubblicato layer " + associatedContent.getTitolo());
            }
        }
        catch (SDIInteractionException e1) {
            report.addMessage(ValidationReport.ValidationStatus.WARNING, "Unable to publish layers " + e1.getMessage());
        }
        conc.setReport(report);
        return conc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void store(AssociatedContent content, List<TempFile> files, WorkspaceManager ws, FolderContainer base) throws Exception {
        FolderContainer sectionParent = null;
        if (content instanceof RelazioneScavo) {
            sectionParent = ws.createFolder(new WorkspaceManager.FolderOptions("relazione", "Relazione di scavo : " + content.getTitolo(), base));
        } else if (content instanceof UploadedImage) {
            sectionParent = ws.createFolder(new WorkspaceManager.FolderOptions("imgs", "Immagini rappresentative : " + content.getTitolo(), base));
        } else if (content instanceof SDILayerDescriptor) {
            if (!(content instanceof LayerConcessione)) throw new Exception("Invalid SDI Content " + content);
            sectionParent = ws.createFolder(new WorkspaceManager.FolderOptions(content.getTitolo(), "Layer Concessione : " + content.getTitolo(), ws.getSubFolder(base, "layers")));
        } else {
            if (!(content instanceof OtherContent)) throw new Exception("Invalid Content " + content);
            sectionParent = ws.createFolder(new WorkspaceManager.FolderOptions(content.getTitolo(), "Relazione di scavo : " + content.getTitolo(), ws.getSubFolder(base, "other")));
        }
        content.setActualContent(new ArrayList());
        StorageClientProvider storage = ImplementationProvider.get().getStorageProvider();
        for (TempFile f : files) {
            WorkspaceContent wsContent = ws.storeToWS(new WorkspaceManager.FileOptions(f.getFilename(), storage.open(f.getId()), "Imported via GeoPortal", sectionParent));
            log.debug("Registered " + wsContent + " for " + content);
            content.getActualContent().add(wsContent);
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

