/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="docs")
public class DocsGenerator {
    private static final Logger log = LoggerFactory.getLogger(DocsGenerator.class);

    @GET
    @Path(value="/{any: .*}")
    public InputStream toDoc(@Context HttpServletRequest req) throws WebApplicationException {
        log.info(DocsGenerator.class.getSimpleName() + " toDoc called");
        String pathInfo = req.getPathInfo();
        log.debug("pathInfo {}", (Object)pathInfo);
        try {
            if (pathInfo.endsWith("/docs/")) {
                pathInfo = pathInfo + "index.html";
            }
            log.info("going to {}", (Object)pathInfo);
            String realPath = req.getServletContext().getRealPath(pathInfo);
            return new FileInputStream(new File(realPath));
        }
        catch (Exception e) {
            log.error("Unexpected exception ", (Throwable)e);
            throw new WebApplicationException("Unexpected Exception : " + e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

