package org.gcube.application.geoportal.service.engine;

import org.gcube.application.geoportal.managers.AbstractRecordManager;
import org.gcube.application.geoportal.service.engine.cache.MongoClientProvider;
import org.gcube.application.geoportal.service.engine.cache.MongoConnectionProvider;

import lombok.Getter;
import lombok.Setter;
import lombok.Synchronized;

public class ImplementationProvider {

	private static ImplementationProvider instance=null;
	
	@Synchronized
	public static ImplementationProvider get() {
		if(instance==null) {
			instance=new ImplementationProvider();
		}
		return instance;
	}
	
	
	@Getter
	@Setter
	private MongoConnectionProvider mongoConnectionProvider=new MongoConnectionProvider();
	
	@Getter
	@Setter
	private MongoClientProvider mongoClientProvider=new MongoClientProvider();
	
	
	@Getter
	@Setter
	private StorageClientProvider storageProvider=new StorageClientProvider();
	
	public void shutdown() {
		// Stop JPA
		AbstractRecordManager.shutdown();
		mongoConnectionProvider.shustdown();
		mongoClientProvider.shustdown();
	}
	
	public void startup() {
		mongoConnectionProvider.init();
		mongoClientProvider.init();
	}
}
