/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.managers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gcube.application.geoportal.managers.AbstractRecordManager;
import org.gcube.application.geoportal.model.InputStreamDescriptor;
import org.gcube.application.geoportal.model.Record;
import org.gcube.application.geoportal.model.concessioni.Concessione;
import org.gcube.application.geoportal.model.concessioni.LayerConcessione;
import org.gcube.application.geoportal.model.concessioni.RelazioneScavo;
import org.gcube.application.geoportal.model.content.UploadedImage;
import org.gcube.application.geoportal.model.db.DBConstants;
import org.gcube.application.geoportal.model.db.PostgisTable;
import org.gcube.application.geoportal.model.fault.SDIInteractionException;
import org.gcube.application.geoportal.storage.ContentHandler;
import org.gcube.application.geoportal.storage.SDIManager;
import org.gcube.application.geoportal.storage.WorkspaceManager;
import org.gcube.application.geoportal.utils.Serialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcessioneManager
extends AbstractRecordManager<Concessione> {
    private static final Logger log = LoggerFactory.getLogger(ConcessioneManager.class);

    protected ConcessioneManager(Concessione theRecord) {
        super(theRecord);
    }

    @Override
    protected PostgisTable getCentroidsTable() {
        return DBConstants.Concessioni.CENTROIDS;
    }

    @Override
    protected void postcommit() {
        this.transaction.begin();
        log.debug("Updating references.. ");
        if (((Concessione)this.getRecord()).getImmaginiRappresentative() != null) {
            for (UploadedImage img : ((Concessione)this.getRecord()).getImmaginiRappresentative()) {
                this.entityManager.createNativeQuery("Update uploadedimage set record_id=" + ((Concessione)this.getRecord()).getId() + " where id = " + img.getId()).executeUpdate();
            }
        }
        if (((Concessione)this.getRecord()).getPianteFineScavo() != null) {
            for (LayerConcessione l : ((Concessione)this.getRecord()).getPianteFineScavo()) {
                this.entityManager.createNativeQuery("Update layerconcessione set record_id=" + ((Concessione)this.getRecord()).getId() + " where id = " + l.getId()).executeUpdate();
                if (l.getWMSLink() != null) {
                    this.entityManager.createNativeQuery("Update layerconcessione set wmslink='" + l.getWMSLink() + "' where id = " + l.getId()).executeUpdate();
                    this.entityManager.createNativeQuery("Update sdilayerdescriptor set wmslink='" + l.getWMSLink() + "' where id = " + l.getId()).executeUpdate();
                }
                if (l.getLayerName() != null) {
                    this.entityManager.createNativeQuery("Update layerconcessione set layername='" + l.getLayerName() + "' where id = " + l.getId()).executeUpdate();
                    this.entityManager.createNativeQuery("Update sdilayerdescriptor set layername='" + l.getLayerName() + "' where id = " + l.getId()).executeUpdate();
                }
                if (l.getLayerID() != null) {
                    this.entityManager.createNativeQuery("Update layerconcessione set layerid='" + l.getLayerID() + "' where id = " + l.getId()).executeUpdate();
                    this.entityManager.createNativeQuery("Update sdilayerdescriptor set layerid='" + l.getLayerID() + "' where id = " + l.getId()).executeUpdate();
                }
                if (l.getLayerUUID() == null) continue;
                this.entityManager.createNativeQuery("Update layerconcessione set layeruuid='" + l.getLayerUUID() + "' where id = " + l.getId()).executeUpdate();
                this.entityManager.createNativeQuery("Update sdilayerdescriptor set layeruuid='" + l.getLayerUUID() + "' where id = " + l.getId()).executeUpdate();
            }
        }
        if (((Concessione)this.getRecord()).getPosizionamentoScavo() != null) {
            LayerConcessione l = ((Concessione)this.getRecord()).getPosizionamentoScavo();
            this.entityManager.createNativeQuery("Update layerconcessione set record_id=" + ((Concessione)this.getRecord()).getId() + " where id = " + l.getId()).executeUpdate();
            if (l.getWMSLink() != null) {
                this.entityManager.createNativeQuery("Update layerconcessione set wmslink='" + l.getWMSLink() + "' where id = " + l.getId()).executeUpdate();
                this.entityManager.createNativeQuery("Update sdilayerdescriptor set wmslink='" + l.getWMSLink() + "' where id = " + l.getId()).executeUpdate();
            }
            if (l.getLayerName() != null) {
                this.entityManager.createNativeQuery("Update layerconcessione set layername='" + l.getLayerName() + "' where id = " + l.getId()).executeUpdate();
                this.entityManager.createNativeQuery("Update sdilayerdescriptor set layername='" + l.getLayerName() + "' where id = " + l.getId()).executeUpdate();
            }
            if (l.getLayerID() != null) {
                this.entityManager.createNativeQuery("Update layerconcessione set layerid='" + l.getLayerID() + "' where id = " + l.getId()).executeUpdate();
                this.entityManager.createNativeQuery("Update sdilayerdescriptor set layerid='" + l.getLayerID() + "' where id = " + l.getId()).executeUpdate();
            }
            if (l.getLayerUUID() != null) {
                this.entityManager.createNativeQuery("Update layerconcessione set layeruuid='" + l.getLayerUUID() + "' where id = " + l.getId()).executeUpdate();
                this.entityManager.createNativeQuery("Update sdilayerdescriptor set layeruuid='" + l.getLayerUUID() + "' where id = " + l.getId()).executeUpdate();
            }
        }
        this.transaction.commit();
    }

    @Override
    protected void initCentroidLayer() throws SDIInteractionException {
        log.debug("Checking for centroid layer configuration.. ");
        SDIManager sdiManager = new SDIManager();
        sdiManager.configureCentroidLayer("centroids_concessioni", "gna", "gna_postgis");
    }

    public Concessione setRelazioneScavo(RelazioneScavo rel, InputStreamDescriptor theFile) throws IOException {
        ContentHandler handler = this.getContentHandler();
        Concessione record = (Concessione)this.getRecord();
        if (record.getRelazioneScavo() != null && !record.getRelazioneScavo().getActualContent().isEmpty()) {
            handler.disposeQuietly(record.getRelazioneScavo());
        }
        rel.setRecord(record);
        record.setRelazioneScavo(rel);
        handler.register(rel, theFile);
        return record;
    }

    public Concessione addImmagineRappresentativa(UploadedImage img, InputStreamDescriptor theFile) throws IOException {
        ContentHandler handler = this.getContentHandler();
        Concessione record = (Concessione)this.getRecord();
        img.setRecord(record);
        if (record.getImmaginiRappresentative() == null) {
            record.setImmaginiRappresentative(new ArrayList<UploadedImage>());
        }
        record.getImmaginiRappresentative().add(img);
        handler.register(img, theFile);
        return record;
    }

    public Concessione setPosizionamento(LayerConcessione layer, InputStreamDescriptor ... inputStreams) throws IOException {
        ContentHandler handler = this.getContentHandler();
        Concessione record = (Concessione)this.getRecord();
        if (record.getPosizionamentoScavo() != null && !record.getPosizionamentoScavo().getActualContent().isEmpty()) {
            handler.disposeQuietly(record.getPosizionamentoScavo());
        }
        layer.setRecord(record);
        record.setPosizionamentoScavo(layer);
        handler.register(layer, inputStreams);
        return record;
    }

    public Concessione addPiantaFineScavo(LayerConcessione layer, InputStreamDescriptor ... inputStreams) throws IOException {
        ContentHandler handler = this.getContentHandler();
        Concessione record = (Concessione)this.getRecord();
        layer.setRecord(record);
        if (record.getPianteFineScavo() == null) {
            record.setPianteFineScavo(new ArrayList<LayerConcessione>());
        }
        record.getPianteFineScavo().add(layer);
        handler.register(layer, inputStreams);
        return record;
    }

    @Override
    protected void onDelete() {
        log.debug("Deleting content for record " + this.getRecord());
        ContentHandler handler = this.getContentHandler();
        Concessione c = (Concessione)this.getRecord();
        handler.disposeQuietly(c.getRelazioneScavo());
        handler.disposeQuietly(c.getPosizionamentoScavo());
        if (c.getImmaginiRappresentative() != null) {
            for (UploadedImage img : c.getImmaginiRappresentative()) {
                handler.disposeQuietly(img);
            }
        }
        if (c.getPianteFineScavo() != null) {
            for (LayerConcessione l : c.getPianteFineScavo()) {
                handler.disposeQuietly(l);
            }
        }
        log.debug("Clearing folder.. ");
        try {
            new WorkspaceManager((Record)this.getRecord()).getWSBase().forceDelete();
        }
        catch (Exception e) {
            log.warn("Unable to delete base folder ", (Throwable)e);
        }
    }

    @Override
    protected Map<String, String> evaluateCentroid() {
        Concessione record = (Concessione)this.getRecord();
        HashMap<String, String> centroidsRow = new HashMap<String, String>();
        centroidsRow.put("product_id", record.getId() + "");
        centroidsRow.put("anno", record.getDataInizioProgetto().getYear() + "");
        centroidsRow.put("nome", record.getNome());
        centroidsRow.put("regione", "");
        centroidsRow.put("xcoord", record.getCentroidLong() + "");
        centroidsRow.put("ycoord", record.getCentroidLat() + "");
        centroidsRow.put("descrizione", record.getIntroduzione());
        centroidsRow.put("contenuto", record.getDescrizioneContenuto());
        centroidsRow.put("autore", Serialization.asString(record.getAuthors()));
        centroidsRow.put("contributore", record.getContributore());
        centroidsRow.put("titolare", Serialization.asString(record.getTitolari()));
        centroidsRow.put("responsabile", record.getResponsabile());
        centroidsRow.put("editore", record.getEditore());
        centroidsRow.put("finanziamento", Serialization.asString(record.getFontiFinanziamento()));
        centroidsRow.put("soggetto", Serialization.asString(record.getSoggetto()));
        centroidsRow.put("risorse", Serialization.asString(record.getRisorseCorrelate()));
        centroidsRow.put("date_scavo", Serialization.FULL_FORMATTER.format(record.getDataFineProgetto()));
        centroidsRow.put("data_archiviazione", Serialization.FULL_FORMATTER.format(record.getLastUpdateTime()));
        centroidsRow.put("versione", record.getVersion());
        centroidsRow.put("licenza", record.getLicenzaID());
        centroidsRow.put("titolare_licenza", Serialization.asString(record.getTitolareLicenza()));
        centroidsRow.put("accesso", record.getPolicy().toString());
        centroidsRow.put("parole_chiave", Serialization.asString(record.getParoleChiaveLibere()));
        return centroidsRow;
    }
}

