/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.storage;

import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.encoder.GSAbstractStoreEncoder;
import it.geosolutions.geoserver.rest.encoder.GSLayerEncoder;
import it.geosolutions.geoserver.rest.encoder.datastore.GSPostGISDatastoreEncoder;
import it.geosolutions.geoserver.rest.encoder.feature.GSFeatureTypeEncoder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.gcube.application.geoportal.model.content.GeoServerContent;
import org.gcube.application.geoportal.model.fault.SDIInteractionException;
import org.gcube.application.geoportal.model.gis.SDILayerDescriptor;
import org.gcube.application.geoportal.storage.TempFile;
import org.gcube.application.geoportal.utils.Files;
import org.gcube.data.transfer.library.DataTransferClient;
import org.gcube.data.transfer.library.TransferResult;
import org.gcube.data.transfer.library.faults.DestinationNotSetException;
import org.gcube.data.transfer.library.faults.FailedTransferException;
import org.gcube.data.transfer.library.faults.InitializationException;
import org.gcube.data.transfer.library.faults.InvalidDestinationException;
import org.gcube.data.transfer.library.faults.InvalidSourceException;
import org.gcube.data.transfer.library.faults.SourceNotSetException;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.spatial.data.gis.GISInterface;
import org.gcube.spatial.data.gis.is.AbstractGeoServerDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDIManager {
    private static final Logger log = LoggerFactory.getLogger(SDIManager.class);
    private static String DEFAULT_CRS = "EPSG:4326";
    private GISInterface gis;
    private DataTransferClient dtGeoServer;
    private String geoserverHostName;

    public SDIManager() throws SDIInteractionException {
        try {
            log.debug("Initializing GIS Interface..");
            this.gis = GISInterface.get((AbstractGeoServerDescriptor[])new AbstractGeoServerDescriptor[0]);
            AbstractGeoServerDescriptor geoserver = this.gis.getCurrentGeoServer();
            if (geoserver == null) {
                throw new Exception("Unable to contact data transfer for geoserver ");
            }
            log.debug("Found geoserver descriptor " + geoserver);
            this.geoserverHostName = new URL(this.gis.getCurrentGeoServer().getUrl()).getHost();
            log.debug("Contacting Data Transfer from geoserver {} ", (Object)this.geoserverHostName);
            this.dtGeoServer = DataTransferClient.getInstanceByEndpoint((String)("http://" + this.geoserverHostName));
        }
        catch (Exception e) {
            throw new SDIInteractionException("Unable to initialize SDI Manager", e);
        }
    }

    public String createWorkspace(String toCreate) throws SDIInteractionException {
        try {
            if (!this.gis.getCurrentGeoServer().getPublisher().createWorkspace(toCreate)) {
                log.warn("Unable to create workspace " + toCreate + ". Assuming already exisintg..");
            }
            return toCreate;
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new SDIInteractionException("Unable to create workspace " + toCreate, e);
        }
    }

    public GeoServerContent pushShapeLayerFileSet(SDILayerDescriptor currentElement, List<TempFile> files, String workspace) throws SDIInteractionException {
        try {
            String remoteFolder = null;
            String fileName = null;
            log.debug("Transferring " + files.size() + " files to geoserver @ " + this.geoserverHostName);
            GeoServerContent content = new GeoServerContent();
            content.setGeoserverHostName(this.geoserverHostName);
            content.setWorkspace(workspace);
            for (TempFile f : files) {
                Destination destination = new Destination(f.getOriginalFileName());
                destination.setCreateSubfolders(Boolean.valueOf(true));
                destination.setOnExistingFileName(DestinationClashPolicy.REWRITE);
                destination.setOnExistingSubFolder(DestinationClashPolicy.ADD_SUFFIX);
                destination.setPersistenceId("geoserver");
                destination.setSubFolder("GNA/" + currentElement.getRecord().getId() + "/" + currentElement.getLayerName());
                TransferResult result = this.dtGeoServer.localFile(f.getTheFile(), destination);
                content.getFileNames().add(f.getOriginalFileName());
                remoteFolder = result.getRemotePath().substring(0, result.getRemotePath().lastIndexOf("/"));
                fileName = f.getOriginalFileName();
                content.setGeoserverPath(remoteFolder);
            }
            String toSetLayerName = fileName.substring(0, fileName.lastIndexOf("."));
            content.setStore(toSetLayerName + "_store");
            content.setFeatureType(toSetLayerName);
            GeoServerRESTPublisher publisher = this.gis.getCurrentGeoServer().getPublisher();
            log.debug("Trying to create remote workspace : " + workspace);
            this.gis.getCurrentGeoServer().getPublisher().createWorkspace(workspace);
            log.debug("Publishing remote folder " + remoteFolder);
            URL directoryPath = new URL("file:" + remoteFolder);
            boolean published = publisher.publishShp(workspace, toSetLayerName + "_store", null, toSetLayerName, GeoServerRESTPublisher.UploadMethod.EXTERNAL, directoryPath.toURI(), DEFAULT_CRS, "");
            if (!published) {
                throw new SDIInteractionException("Unable to publish layer " + toSetLayerName + " under " + workspace + ". Unknown Geoserver fault.");
            }
            currentElement.setLayerName(toSetLayerName);
            return content;
        }
        catch (DestinationNotSetException | FailedTransferException | InitializationException | InvalidDestinationException | InvalidSourceException | SourceNotSetException e) {
            throw new SDIInteractionException("Unable to transfer fileSet for content " + currentElement, e);
        }
        catch (SDIInteractionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SDIInteractionException("Unexpected internal fault while interacting with SDI.", t);
        }
    }

    private String createStoreFromPostgisDB(String workspace, String storeName) throws SDIInteractionException {
        GSPostGISDatastoreEncoder encoder = new GSPostGISDatastoreEncoder(storeName);
        encoder.setJndiReferenceName("java:comp/env/jdbc/postgres");
        encoder.setLooseBBox(true);
        encoder.setDatabaseType("postgis");
        encoder.setEnabled(true);
        encoder.setFetchSize(1000);
        encoder.setValidateConnections(true);
        try {
            if (!this.gis.getCurrentGeoServer().getDataStoreManager().create(workspace, (GSAbstractStoreEncoder)encoder)) {
                log.warn("Unable to create workspace " + storeName + ". Assuming already exisintg..");
            }
            return storeName;
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new SDIInteractionException("Unable to create store " + storeName, e);
        }
    }

    private String publishLayer(File sldFile, String name) throws SDIInteractionException {
        try {
            if (!this.gis.getCurrentGeoServer().getPublisher().publishStyle(sldFile, name)) {
                log.warn("Unable to create style " + name + ". Assuming already exisintg..");
            }
            return name;
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new SDIInteractionException("Unable to create style " + name, e);
        }
    }

    public String configureCentroidLayer(String name, String workspace, String storeName) throws SDIInteractionException {
        GSFeatureTypeEncoder fte = new GSFeatureTypeEncoder();
        fte.setAbstract("Centroid layer for " + name);
        fte.setEnabled(true);
        fte.setNativeCRS(DEFAULT_CRS);
        fte.setTitle(name);
        String style = "clustered_centroids";
        GSLayerEncoder layerEncoder = new GSLayerEncoder();
        layerEncoder.setDefaultStyle(style);
        layerEncoder.setEnabled(true);
        layerEncoder.setQueryable(Boolean.valueOf(true));
        try {
            this.createWorkspace(workspace);
            this.createStoreFromPostgisDB(workspace, storeName);
            this.publishLayer(Files.getFileFromResources("styles/clustered_points.sld"), style);
            if (!this.gis.getCurrentGeoServer().getPublisher().publishDBLayer(workspace, storeName, fte, layerEncoder)) {
                log.warn("Unable to create layer " + name + ". Assuming already exisintg..");
            }
            return name;
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new SDIInteractionException("Unable to create layer " + name, e);
        }
    }
}

