/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.time.LocalDateTime;
import org.gcube.application.geoportal.model.Record;
import org.gcube.application.geoportal.model.content.WorkspaceContent;
import org.gcube.application.geoportal.utils.Serialization;
import org.gcube.application.geoportal.utils.Workspace;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceManager {
    private static final Logger log = LoggerFactory.getLogger(WorkspaceManager.class);
    private Record record;
    private StorageHubClient sgClient = null;
    private FolderContainer wsBase = null;
    private FolderContainer appBase = null;
    private static final String APP_FOLDER = ".GNA_RECORDS";

    public WorkspaceManager(Record record) {
        this.record = record;
    }

    private StorageHubClient getSGClient() {
        if (this.sgClient == null) {
            this.sgClient = Workspace.getClient();
        }
        return this.sgClient;
    }

    private FolderContainer getApplicationBaseFolder() throws StorageHubException {
        if (this.appBase == null) {
            StorageHubClient client = this.getSGClient();
            FolderContainer vre = client.openVREFolder();
            try {
                this.appBase = vre.openByRelativePath(APP_FOLDER).asFolder();
            }
            catch (StorageHubException e) {
                log.debug("APP Fodler missing. Initializing..");
                this.appBase = vre.newFolder(APP_FOLDER, "Base folder for GNA records");
                this.appBase.setHidden();
            }
        }
        return this.appBase;
    }

    private FolderContainer getWSBase() throws StorageHubException {
        if (this.wsBase == null) {
            log.debug("WSBASE not set");
            if (this.record.getFolderId() == null) {
                log.debug("Initializing record folder..");
                String creationTime = Serialization.FULL_FORMATTER.format(LocalDateTime.now());
                String folderName = (Object)((Object)this.record.getRecordType()) + "_" + this.record.getNome() + "_" + creationTime;
                log.debug("Folder name will be " + folderName);
                this.wsBase = this.getApplicationBaseFolder().newFolder(folderName, "Base folder del record " + this.record.getNome());
                this.record.setFolderId(this.wsBase.getId());
            }
            log.debug("Opening folder");
            this.wsBase = this.getSGClient().open(this.record.getFolderId()).asFolder();
        }
        return this.wsBase;
    }

    public FolderContainer getSubFolder(String path) throws StorageHubException {
        return this.getSubFolder(this.getWSBase(), path);
    }

    private FolderContainer getSubFolder(FolderContainer parentFolder, String path) throws StorageHubException {
        try {
            return parentFolder.openByRelativePath(path).asFolder();
        }
        catch (StorageHubException e) {
            log.debug("Missing subPath " + path);
            FolderContainer targetParent = parentFolder;
            String targetName = path;
            if (path.contains("/")) {
                String parent = path.substring(0, path.lastIndexOf("/"));
                log.debug("Checking intermediate " + parent);
                targetParent = this.getSubFolder(parentFolder, parent);
                targetName = path.substring(path.lastIndexOf("/") + 1);
            }
            log.debug("Creating " + targetName);
            return targetParent.newFolder(targetName, "");
        }
    }

    public WorkspaceContent storeToWS(File f, FolderContainer destination, String name, String description) throws FileNotFoundException, StorageHubException {
        FileContainer item = destination.uploadFile((InputStream)new FileInputStream(f), name, description);
        item = this.getSGClient().open(item.getId()).asFile();
        WorkspaceContent content = new WorkspaceContent();
        content.setLink(item.getPublicLink().toString());
        content.setMimetype(((AbstractFileItem)item.get()).getContent().getMimeType());
        content.setStorageID(item.getId());
        return content;
    }
}

