/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.storage;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.gcube.application.geoportal.model.db.DatabaseConnection;
import org.gcube.application.geoportal.model.db.PostgisTable;
import org.gcube.application.geoportal.model.fault.ConfigurationException;
import org.gcube.application.geoportal.model.fault.DataParsingException;
import org.gcube.application.geoportal.model.gis.BBOX;
import org.gcube.application.geoportal.storage.PostgisDBManagerI;
import org.gcube.application.geoportal.utils.DBUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgisDBManager
implements PostgisDBManagerI {
    private static final Logger log = LoggerFactory.getLogger(PostgisDBManager.class);
    private static final Object $LOCK = new Object[0];
    private static DatabaseConnection config;
    private Connection conn = PostgisDBManager.getConnection();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PostgisDBManager get() throws SQLException, ConfigurationException {
        Object object = $LOCK;
        synchronized (object) {
            if (config == null) {
                log.debug("Looking for Default Configuration.. ");
                DatabaseConnection defaultConfiguration = DatabaseConnection.get(DatabaseConnection.TYPE.Concessioni);
                log.debug("Found configuration :  " + defaultConfiguration);
                config = defaultConfiguration;
            }
            return new PostgisDBManager();
        }
    }

    public static PostgisDBManagerI get(boolean autocommit) throws SQLException, ConfigurationException {
        PostgisDBManager toReturn = PostgisDBManager.get();
        toReturn.conn.setAutoCommit(autocommit);
        return toReturn;
    }

    public static void init(DatabaseConnection config) throws SQLException, IOException {
        PostgisDBManager.config = config;
        try {
            Class.forName("org.postgresql.Driver");
            Class.forName("org.postgis.DriverWrapper");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Connection getConnection() throws SQLException {
        Connection toReturn = DriverManager.getConnection(config.getUrl(), config.getUser(), config.getPwd());
        toReturn.setAutoCommit(config.getAutocommit());
        return toReturn;
    }

    private PostgisDBManager() throws SQLException {
    }

    @Override
    public void create(PostgisTable toCreate) throws SQLException {
        String createStmt = toCreate.getCreateStatement();
        log.debug("Executing create : " + createStmt);
        this.conn.createStatement().executeUpdate(createStmt);
    }

    @Override
    public void commit() throws SQLException {
        this.conn.commit();
    }

    @Override
    public BBOX evaluateBoundingBox(PostgisTable table) throws SQLException, DataParsingException {
        ResultSet rs = this.conn.createStatement().executeQuery("Select ST_Extent(" + table.getGeometryColumn() + ") as extent from " + table.getTablename());
        if (rs.next()) {
            return DBUtils.parseST_Extent(rs.getString("extent"));
        }
        throw new SQLException("No extent returned");
    }

    @Override
    public PostgisTable.POINT evaluateCentroid(PostgisTable table) throws SQLException, DataParsingException {
        ResultSet rs = this.conn.createStatement().executeQuery("Select ST_AsText(ST_Centroid(ST_Collect(" + table.getGeometryColumn() + "))) as centroid from " + table.getTablename());
        if (rs.next()) {
            return PostgisTable.POINT.parsePOINT(rs.getString("centroid"));
        }
        throw new SQLException("No extent returned");
    }

    @Override
    public PreparedStatement prepareInsertStatement(PostgisTable target, boolean createTable, boolean geometryAsText) throws SQLException {
        if (createTable) {
            this.create(target);
        }
        String insertStmt = target.getInsertionStatement(geometryAsText);
        log.debug("Preparing insert statement : " + insertStmt);
        return this.conn.prepareStatement(insertStmt);
    }

    @Override
    public int deleteByFieldValue(PostgisTable target, PostgisTable.Field field, Object value) throws SQLException {
        PreparedStatement stmt = this.conn.prepareStatement(target.getDeleteByFieldStatement(field));
        target.setObjectInPreparedStatement(field, value, stmt, 1);
        return stmt.executeUpdate();
    }

    @Override
    public void deleteTable(String tableName) throws SQLException {
        this.conn.createStatement().executeUpdate("DROP TABLE " + tableName);
    }

    @Override
    public void truncate(String tableName) throws SQLException {
        this.conn.createStatement().executeUpdate("TRUNCATE Table " + tableName);
    }

    @Override
    public ResultSet queryAll(PostgisTable table) throws SQLException {
        return this.conn.createStatement().executeQuery("Select * from " + table.getTablename());
    }
}

