/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.storage;

import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.gcube.application.geoportal.model.content.GeoServerContent;
import org.gcube.application.geoportal.model.fault.SDIInteractionException;
import org.gcube.application.geoportal.model.gis.SDILayerDescriptor;
import org.gcube.application.geoportal.storage.TempFile;
import org.gcube.data.transfer.library.DataTransferClient;
import org.gcube.data.transfer.library.TransferResult;
import org.gcube.data.transfer.library.faults.DestinationNotSetException;
import org.gcube.data.transfer.library.faults.FailedTransferException;
import org.gcube.data.transfer.library.faults.InitializationException;
import org.gcube.data.transfer.library.faults.InvalidDestinationException;
import org.gcube.data.transfer.library.faults.InvalidSourceException;
import org.gcube.data.transfer.library.faults.SourceNotSetException;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.spatial.data.gis.GISInterface;
import org.gcube.spatial.data.gis.is.AbstractGeoServerDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDIManager {
    private static final Logger log = LoggerFactory.getLogger(SDIManager.class);
    private GISInterface gis;
    private DataTransferClient dtGeoServer;
    private String geoserverHostName;

    public SDIManager() throws SDIInteractionException {
        try {
            log.debug("Initializing GIS Interface..");
            this.gis = GISInterface.get((AbstractGeoServerDescriptor[])new AbstractGeoServerDescriptor[0]);
            AbstractGeoServerDescriptor geoserver = this.gis.getCurrentGeoServer();
            if (geoserver == null) {
                throw new Exception("Unable to contact data transfer for geoserver ");
            }
            log.debug("Found geoserver descriptor " + geoserver);
            this.geoserverHostName = new URL(this.gis.getCurrentGeoServer().getUrl()).getHost();
            log.debug("Contacting Data Transfer from geoserver {} ", (Object)this.geoserverHostName);
            this.dtGeoServer = DataTransferClient.getInstanceByEndpoint((String)("http://" + this.geoserverHostName));
        }
        catch (Exception e) {
            throw new SDIInteractionException("Unable to initialize SDI Manager", e);
        }
    }

    public String createWorkspace(String toCreate) throws SDIInteractionException {
        try {
            if (!this.gis.getCurrentGeoServer().getPublisher().createWorkspace(toCreate)) {
                log.warn("Unable to create workspace " + toCreate + ". Assuming already exisintg..");
            }
            return toCreate;
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new SDIInteractionException("Unable to create workspace " + toCreate, e);
        }
    }

    public GeoServerContent pushShapeLayerFileSet(SDILayerDescriptor currentElement, List<TempFile> files, String workspace) throws SDIInteractionException {
        try {
            String remoteFolder = null;
            String fileName = null;
            long projectInternalID = currentElement.getRecord().getId();
            long layerInternalID = currentElement.getId();
            log.debug("Transferring " + files.size() + " files to geoserver @ " + this.geoserverHostName);
            GeoServerContent content = new GeoServerContent();
            content.setGeoserverHostName(this.geoserverHostName);
            content.setWorkspace(workspace);
            for (TempFile f : files) {
                Destination destination = new Destination(f.getOriginalFileName());
                destination.setCreateSubfolders(Boolean.valueOf(true));
                destination.setOnExistingFileName(DestinationClashPolicy.REWRITE);
                destination.setPersistenceId("geoserver");
                destination.setSubFolder("GNA/" + projectInternalID + "/" + layerInternalID);
                TransferResult result = this.dtGeoServer.localFile(f.getTheFile(), destination);
                content.getFileNames().add(f.getOriginalFileName());
                remoteFolder = result.getRemotePath();
                fileName = f.getOriginalFileName();
                content.setGeoserverPath(result.getRemotePath());
            }
            String toSetLayerName = fileName.substring(0, fileName.lastIndexOf("."));
            content.setStore(toSetLayerName + "_store");
            content.setFeatureType(toSetLayerName);
            GeoServerRESTPublisher publisher = this.gis.getCurrentGeoServer().getPublisher();
            log.debug("Trying to create remote workspace : " + workspace);
            this.gis.getCurrentGeoServer().getPublisher().createWorkspace(workspace);
            log.debug("Publishing remote folder " + remoteFolder);
            URL directoryPath = new URL("file:" + remoteFolder.substring(0, remoteFolder.lastIndexOf("/")));
            String DEFAULT_CRS = "EPSG:4326";
            boolean published = publisher.publishShp(workspace, toSetLayerName + "_store", null, toSetLayerName, GeoServerRESTPublisher.UploadMethod.EXTERNAL, directoryPath.toURI(), DEFAULT_CRS, "");
            if (!published) {
                throw new SDIInteractionException("Unable to publish layer " + toSetLayerName + " under " + workspace + ". Unknown Geoserver fault.");
            }
            currentElement.setLayerName(toSetLayerName);
            return content;
        }
        catch (DestinationNotSetException | FailedTransferException | InitializationException | InvalidDestinationException | InvalidSourceException | SourceNotSetException e) {
            throw new SDIInteractionException("Unable to transfer fileSet for content " + currentElement, e);
        }
        catch (SDIInteractionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SDIInteractionException("Unexpected internal fault while interacting with SDI.", t);
        }
    }
}

