/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.model.content;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.gcube.application.geoportal.model.AccessPolicy;
import org.gcube.application.geoportal.model.Record;
import org.gcube.application.geoportal.model.content.PersistedContent;
import org.gcube.application.geoportal.model.report.Check;
import org.gcube.application.geoportal.model.report.ValidationReport;
import org.gcube.application.geoportal.utils.CollectionsUtils;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class AssociatedContent {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    private AccessPolicy policy;
    private String licenseID;
    private String titolo;
    private LocalDateTime creationTime;
    @ManyToOne
    @JoinColumn(name="record_id", nullable=false)
    private Record record;
    @OneToMany(mappedBy="associated", cascade={CascadeType.ALL})
    private List<PersistedContent> actualContent = new ArrayList<PersistedContent>();

    public ValidationReport validateForInsertion() {
        ValidationReport toReturn = new ValidationReport("Associated Content");
        toReturn.checkMandatory(this.policy, "Politica di accesso", new Check[0]);
        toReturn.checkMandatory(this.licenseID, "Licenza", new Check[0]);
        toReturn.checkMandatory(this.titolo, "Titolo", new Check[0]);
        toReturn.checkMandatory(this.creationTime, "Creation time", new Check[0]);
        return toReturn;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + CollectionsUtils.hashCode(this.actualContent);
        result = 31 * result + (this.creationTime == null ? 0 : this.creationTime.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.licenseID == null ? 0 : this.licenseID.hashCode());
        result = 31 * result + (this.policy == null ? 0 : this.policy.hashCode());
        result = 31 * result + (this.titolo == null ? 0 : this.titolo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssociatedContent other = (AssociatedContent)obj;
        if (!CollectionsUtils.equalsCollections(this.actualContent, other.actualContent)) {
            return false;
        }
        if (this.creationTime == null ? other.creationTime != null : !this.creationTime.equals(other.creationTime)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.licenseID == null ? other.licenseID != null : !this.licenseID.equals(other.licenseID)) {
            return false;
        }
        if (this.policy != other.policy) {
            return false;
        }
        return !(this.titolo == null ? other.titolo != null : !this.titolo.equals(other.titolo));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AssociatedContent [id=");
        builder.append(this.id);
        if (this.record != null) {
            builder.append(", owner-record-id=");
            builder.append(this.record.getId());
        } else {
            builder.append(", record=");
            builder.append(this.record);
        }
        builder.append(", policy=");
        builder.append((Object)this.policy);
        builder.append(", licenseID=");
        builder.append(this.licenseID);
        builder.append(", titolo=");
        builder.append(this.titolo);
        builder.append(", creationTime=");
        builder.append(this.creationTime);
        builder.append(", actualContent=");
        builder.append(this.actualContent);
        builder.append("]");
        return builder.toString();
    }

    public long getId() {
        return this.id;
    }

    public AccessPolicy getPolicy() {
        return this.policy;
    }

    public String getLicenseID() {
        return this.licenseID;
    }

    public String getTitolo() {
        return this.titolo;
    }

    public LocalDateTime getCreationTime() {
        return this.creationTime;
    }

    public Record getRecord() {
        return this.record;
    }

    public List<PersistedContent> getActualContent() {
        return this.actualContent;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setPolicy(AccessPolicy policy) {
        this.policy = policy;
    }

    public void setLicenseID(String licenseID) {
        this.licenseID = licenseID;
    }

    public void setTitolo(String titolo) {
        this.titolo = titolo;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public void setRecord(Record record) {
        this.record = record;
    }

    public void setActualContent(List<PersistedContent> actualContent) {
        this.actualContent = actualContent;
    }
}

