/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.model.concessioni;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.gcube.application.geoportal.model.AccessPolicy;
import org.gcube.application.geoportal.model.Record;
import org.gcube.application.geoportal.model.RecordType;
import org.gcube.application.geoportal.model.concessioni.LayerConcessione;
import org.gcube.application.geoportal.model.concessioni.RelazioneScavo;
import org.gcube.application.geoportal.model.content.OtherContent;
import org.gcube.application.geoportal.model.content.UploadedImage;
import org.gcube.application.geoportal.model.gis.BBOX;
import org.gcube.application.geoportal.model.report.Check;
import org.gcube.application.geoportal.model.report.ConstraintCheck;
import org.gcube.application.geoportal.model.report.ValidationReport;
import org.gcube.application.geoportal.utils.CollectionsUtils;

@Entity
@DiscriminatorValue(value="CONCESSIONE")
public class Concessione
extends Record {
    private String introduzione;
    private String descrizioneContenuto;
    @ElementCollection(targetClass=String.class)
    private List<String> authors;
    private String contributore;
    @ElementCollection(targetClass=String.class)
    private List<String> titolari;
    private String responsabile;
    private String editore;
    @ElementCollection(targetClass=String.class)
    private List<String> fontiFinanziamento;
    @ElementCollection(targetClass=String.class)
    private List<String> soggetto;
    @ElementCollection(targetClass=String.class)
    private List<String> risorseCorrelate;
    private LocalDateTime dataInizioProgetto;
    private LocalDateTime dataFineProgetto;
    private String titolareLicenza;
    private String titolareCopyright;
    @ElementCollection(targetClass=String.class)
    private List<String> paroleChiaveLibere;
    @ElementCollection(targetClass=String.class)
    private List<String> paroleChiaveICCD;
    private Double centroidLat;
    private Double centroidLong;
    @OneToOne(cascade={CascadeType.ALL})
    private RelazioneScavo relazioneScavo;
    @OneToMany(mappedBy="record", cascade={CascadeType.ALL})
    private List<UploadedImage> immaginiRappresentative = new ArrayList<UploadedImage>();
    @OneToOne(cascade={CascadeType.ALL})
    private LayerConcessione posizionamentoScavo;
    @OneToMany(mappedBy="record", cascade={CascadeType.ALL})
    private List<LayerConcessione> pianteFineScavo = new ArrayList<LayerConcessione>();
    @OneToMany(mappedBy="record", cascade={CascadeType.ALL})
    private List<OtherContent> genericContent = new ArrayList<OtherContent>();

    public Concessione() {
        this.setRecordType(RecordType.CONCESSIONE);
    }

    @Override
    public ValidationReport validate() {
        ValidationReport validator = super.validate();
        validator.setObjectName("Concessione");
        this.setPolicy(AccessPolicy.OPEN);
        validator.checkMandatory(this.authors, "Lista Autori", new Check[0]);
        if (validator.checkMandatory(this.centroidLat, "Latitudine", new Check[0]) && (this.centroidLat > 90.0 || this.centroidLat < -90.0)) {
            validator.addMessage(ValidationReport.ValidationStatus.ERROR, "Latitudine non valida : " + this.centroidLat);
        }
        if (validator.checkMandatory(this.centroidLong, "Longitudine", new Check[0]) && (this.centroidLong > 180.0 || this.centroidLong < -180.0)) {
            validator.addMessage(ValidationReport.ValidationStatus.ERROR, "Longitudine non valida : " + this.centroidLong);
        }
        validator.checkMandatory(this.contributore, "Contributore", new Check[0]);
        if (validator.checkMandatory(this.dataFineProgetto, "Data Fine Progetto", new Check[0]) && validator.checkMandatory(this.dataInizioProgetto, "Data Inizio Progetto", new Check[0]) && this.dataFineProgetto.isBefore(this.dataInizioProgetto)) {
            validator.addMessage(ValidationReport.ValidationStatus.ERROR, "Data Fine Progetto non pu\u00f2 esser prima di Data Inizio Progetto.");
        }
        validator.checkMandatory(this.descrizioneContenuto, "Descrizione contenuto", new Check[0]);
        validator.checkMandatory(this.editore, "Editore", new Check[0]);
        validator.checkMandatory(this.fontiFinanziamento, "Fonti Finanaziamento", new Check[0]);
        validator.checkMandatory(this.introduzione, "Introduzione", new Check[0]);
        validator.checkMandatory(this.paroleChiaveICCD, "Parole chiave ICCD", new Check[0]);
        validator.checkMandatory(this.paroleChiaveLibere, "Parole chiave libere", new Check[0]);
        validator.checkMandatory(this.responsabile, "Responsabile", new Check[0]);
        validator.checkMandatory(this.titolareCopyright, "Titolare Copyright", new Check[0]);
        validator.checkMandatory(this.titolareLicenza, "Titolare licenza", new Check[0]);
        validator.checkMandatory(this.titolari, "Titolari", new Check[0]);
        if (validator.checkMandatory(this.relazioneScavo, "Relazione scavo", new Check[0])) {
            this.relazioneScavo.setLicenzaID(this.getLicenzaID());
            this.relazioneScavo.setPolicy(this.getPolicy());
            validator.addChild(this.relazioneScavo.validateForInsertion());
        }
        if (validator.checkMandatory(this.posizionamentoScavo, "Posizionamento scavo", new Check[0])) {
            ValidationReport posReport = this.posizionamentoScavo.validateForInsertion();
            posReport.setObjectName("Posizionamento scavo");
            validator.addChild(posReport);
        }
        if (this.genericContent != null) {
            for (OtherContent content : this.genericContent) {
                validator.addChild(content.validateForInsertion());
            }
        }
        if (validator.checkMandatory(this.pianteFineScavo, "Piante fine scavo", new Check[0])) {
            for (LayerConcessione l : this.pianteFineScavo) {
                validator.addChild(l.validateForInsertion());
            }
        }
        return validator;
    }

    @Override
    public void setDefaults() {
        super.setDefaults();
        this.setSoggetto(ConstraintCheck.defaultFor(this.soggetto, Arrays.asList("Research Excavation", "Archaeology")).addChecks(Check.collectionSizeMin(2)).evaluate());
        if (this.relazioneScavo != null) {
            this.relazioneScavo.setTitolo(ConstraintCheck.defaultFor(this.relazioneScavo.getTitolo(), this.getNome() + " relazione di scavo").evaluate());
            this.relazioneScavo.setSoggetto(ConstraintCheck.defaultFor(this.relazioneScavo.getSoggetto(), this.getSoggetto()).evaluate());
            this.relazioneScavo.setCreationTime(ConstraintCheck.defaultFor(this.relazioneScavo.getCreationTime(), this.getCreationTime()).evaluate());
        }
        if (this.immaginiRappresentative != null) {
            for (UploadedImage img : this.immaginiRappresentative) {
                img.setSoggetto(ConstraintCheck.defaultFor(img.getSoggetto(), this.getSoggetto()).evaluate());
                img.setCreationTime(ConstraintCheck.defaultFor(img.getCreationTime(), this.getCreationTime()).evaluate());
                img.setPolicy(ConstraintCheck.defaultFor(img.getPolicy(), this.getPolicy()).evaluate());
                img.setLicenzaID(ConstraintCheck.defaultFor(img.getLicenzaID(), this.getLicenzaID()).evaluate());
            }
        }
        if (this.posizionamentoScavo != null) {
            this.posizionamentoScavo.setTitolo(ConstraintCheck.defaultFor(this.posizionamentoScavo.getTitolo(), this.getNome() + " posizionamento scavo").evaluate());
            this.posizionamentoScavo.setAbstractSection(ConstraintCheck.defaultFor(this.posizionamentoScavo.getAbstractSection(), "Posizionamento topografico georeferenziato dell\u2019area interessata dalle indagini").evaluate());
            this.posizionamentoScavo.setTopicCategory(ConstraintCheck.defaultFor(this.posizionamentoScavo.getTopicCategory(), "Society").evaluate());
            this.posizionamentoScavo.setSubTopic(ConstraintCheck.defaultFor(this.posizionamentoScavo.getSubTopic(), "Archeology").evaluate());
            this.posizionamentoScavo.setParoleChiaveLibere(ConstraintCheck.defaultFor(this.posizionamentoScavo.getParoleChiaveLibere(), this.getParoleChiaveLibere()).evaluate());
            this.posizionamentoScavo.setParoleChiaveICCD(ConstraintCheck.defaultFor(this.posizionamentoScavo.getParoleChiaveICCD(), this.getParoleChiaveICCD()).evaluate());
            this.posizionamentoScavo.setBbox(ConstraintCheck.defaultFor(this.posizionamentoScavo.getBbox(), BBOX.WORLD_EXTENT).evaluate());
            this.posizionamentoScavo.setPolicy(ConstraintCheck.defaultFor(this.posizionamentoScavo.getPolicy(), this.getPolicy()).evaluate());
            this.posizionamentoScavo.setLicenzaID("CC-BY");
            this.posizionamentoScavo.setResponsabile(this.getResponsabile());
            this.posizionamentoScavo.setCreationTime(ConstraintCheck.defaultFor(this.posizionamentoScavo.getCreationTime(), this.getCreationTime()).evaluate());
        }
        if (this.pianteFineScavo != null) {
            for (LayerConcessione l : this.pianteFineScavo) {
                l.setTitolo(ConstraintCheck.defaultFor(l.getTitolo(), this.getNome() + " pianta fine scavo").evaluate());
                l.setAbstractSection(ConstraintCheck.defaultFor(l.getAbstractSection(), "Planimetria georeferenziata dell'area indagata al termine delle attivit\u00e0").evaluate());
                l.setTopicCategory(ConstraintCheck.defaultFor(l.getTopicCategory(), "Society").evaluate());
                l.setSubTopic(ConstraintCheck.defaultFor(l.getSubTopic(), "Archeology").evaluate());
                l.setParoleChiaveLibere(ConstraintCheck.defaultFor(l.getParoleChiaveLibere(), this.getParoleChiaveLibere()).evaluate());
                l.setParoleChiaveICCD(ConstraintCheck.defaultFor(l.getParoleChiaveICCD(), this.getParoleChiaveICCD()).evaluate());
                l.setBbox(ConstraintCheck.defaultFor(l.getBbox(), BBOX.WORLD_EXTENT).evaluate());
                l.setPolicy(ConstraintCheck.defaultFor(l.getPolicy(), this.getPolicy()).evaluate());
                l.setLicenzaID(ConstraintCheck.defaultFor(l.getLicenzaID(), "CC-BY").evaluate());
                l.setResponsabile(this.getResponsabile());
                l.setCreationTime(ConstraintCheck.defaultFor(l.getCreationTime(), this.getCreationTime()).evaluate());
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + CollectionsUtils.hashCode(this.authors);
        result = 31 * result + CollectionsUtils.hashCode(this.fontiFinanziamento);
        result = 31 * result + CollectionsUtils.hashCode(this.immaginiRappresentative);
        result = 31 * result + CollectionsUtils.hashCode(this.paroleChiaveICCD);
        result = 31 * result + CollectionsUtils.hashCode(this.paroleChiaveLibere);
        result = 31 * result + CollectionsUtils.hashCode(this.pianteFineScavo);
        result = 31 * result + CollectionsUtils.hashCode(this.risorseCorrelate);
        result = 31 * result + CollectionsUtils.hashCode(this.soggetto);
        result = 31 * result + CollectionsUtils.hashCode(this.titolari);
        result = 31 * result + (this.centroidLat == null ? 0 : this.centroidLat.hashCode());
        result = 31 * result + (this.centroidLong == null ? 0 : this.centroidLong.hashCode());
        result = 31 * result + (this.contributore == null ? 0 : this.contributore.hashCode());
        result = 31 * result + (this.dataFineProgetto == null ? 0 : this.dataFineProgetto.hashCode());
        result = 31 * result + (this.dataInizioProgetto == null ? 0 : this.dataInizioProgetto.hashCode());
        result = 31 * result + (this.descrizioneContenuto == null ? 0 : this.descrizioneContenuto.hashCode());
        result = 31 * result + (this.editore == null ? 0 : this.editore.hashCode());
        result = 31 * result + (this.genericContent == null ? 0 : this.genericContent.hashCode());
        result = 31 * result + (this.introduzione == null ? 0 : this.introduzione.hashCode());
        result = 31 * result + (this.posizionamentoScavo == null ? 0 : this.posizionamentoScavo.hashCode());
        result = 31 * result + (this.relazioneScavo == null ? 0 : this.relazioneScavo.hashCode());
        result = 31 * result + (this.responsabile == null ? 0 : this.responsabile.hashCode());
        result = 31 * result + (this.titolareCopyright == null ? 0 : this.titolareCopyright.hashCode());
        result = 31 * result + (this.titolareLicenza == null ? 0 : this.titolareLicenza.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Concessione other = (Concessione)obj;
        if (!CollectionsUtils.equalsCollections(this.authors, other.authors)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.fontiFinanziamento, other.fontiFinanziamento)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.immaginiRappresentative, other.immaginiRappresentative)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.paroleChiaveICCD, other.paroleChiaveICCD)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.paroleChiaveLibere, other.paroleChiaveLibere)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.pianteFineScavo, other.pianteFineScavo)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.risorseCorrelate, other.risorseCorrelate)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.soggetto, other.soggetto)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.titolari, other.titolari)) {
            return false;
        }
        if (this.centroidLat == null ? other.centroidLat != null : !this.centroidLat.equals(other.centroidLat)) {
            return false;
        }
        if (this.centroidLong == null ? other.centroidLong != null : !this.centroidLong.equals(other.centroidLong)) {
            return false;
        }
        if (this.contributore == null ? other.contributore != null : !this.contributore.equals(other.contributore)) {
            return false;
        }
        if (this.dataFineProgetto == null ? other.dataFineProgetto != null : !this.dataFineProgetto.equals(other.dataFineProgetto)) {
            return false;
        }
        if (this.dataInizioProgetto == null ? other.dataInizioProgetto != null : !this.dataInizioProgetto.equals(other.dataInizioProgetto)) {
            return false;
        }
        if (this.descrizioneContenuto == null ? other.descrizioneContenuto != null : !this.descrizioneContenuto.equals(other.descrizioneContenuto)) {
            return false;
        }
        if (this.editore == null ? other.editore != null : !this.editore.equals(other.editore)) {
            return false;
        }
        if (this.genericContent == null ? other.genericContent != null : !this.genericContent.equals(other.genericContent)) {
            return false;
        }
        if (this.introduzione == null ? other.introduzione != null : !this.introduzione.equals(other.introduzione)) {
            return false;
        }
        if (this.posizionamentoScavo == null ? other.posizionamentoScavo != null : !this.posizionamentoScavo.equals(other.posizionamentoScavo)) {
            return false;
        }
        if (this.relazioneScavo == null ? other.relazioneScavo != null : !this.relazioneScavo.equals(other.relazioneScavo)) {
            return false;
        }
        if (this.responsabile == null ? other.responsabile != null : !this.responsabile.equals(other.responsabile)) {
            return false;
        }
        if (this.titolareCopyright == null ? other.titolareCopyright != null : !this.titolareCopyright.equals(other.titolareCopyright)) {
            return false;
        }
        return !(this.titolareLicenza == null ? other.titolareLicenza != null : !this.titolareLicenza.equals(other.titolareLicenza));
    }

    public String getIntroduzione() {
        return this.introduzione;
    }

    public String getDescrizioneContenuto() {
        return this.descrizioneContenuto;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public String getContributore() {
        return this.contributore;
    }

    public List<String> getTitolari() {
        return this.titolari;
    }

    public String getResponsabile() {
        return this.responsabile;
    }

    public String getEditore() {
        return this.editore;
    }

    public List<String> getFontiFinanziamento() {
        return this.fontiFinanziamento;
    }

    public List<String> getSoggetto() {
        return this.soggetto;
    }

    public List<String> getRisorseCorrelate() {
        return this.risorseCorrelate;
    }

    public LocalDateTime getDataInizioProgetto() {
        return this.dataInizioProgetto;
    }

    public LocalDateTime getDataFineProgetto() {
        return this.dataFineProgetto;
    }

    public String getTitolareLicenza() {
        return this.titolareLicenza;
    }

    public String getTitolareCopyright() {
        return this.titolareCopyright;
    }

    public List<String> getParoleChiaveLibere() {
        return this.paroleChiaveLibere;
    }

    public List<String> getParoleChiaveICCD() {
        return this.paroleChiaveICCD;
    }

    public Double getCentroidLat() {
        return this.centroidLat;
    }

    public Double getCentroidLong() {
        return this.centroidLong;
    }

    public RelazioneScavo getRelazioneScavo() {
        return this.relazioneScavo;
    }

    public List<UploadedImage> getImmaginiRappresentative() {
        return this.immaginiRappresentative;
    }

    public LayerConcessione getPosizionamentoScavo() {
        return this.posizionamentoScavo;
    }

    public List<LayerConcessione> getPianteFineScavo() {
        return this.pianteFineScavo;
    }

    public List<OtherContent> getGenericContent() {
        return this.genericContent;
    }

    public void setIntroduzione(String introduzione) {
        this.introduzione = introduzione;
    }

    public void setDescrizioneContenuto(String descrizioneContenuto) {
        this.descrizioneContenuto = descrizioneContenuto;
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors;
    }

    public void setContributore(String contributore) {
        this.contributore = contributore;
    }

    public void setTitolari(List<String> titolari) {
        this.titolari = titolari;
    }

    public void setResponsabile(String responsabile) {
        this.responsabile = responsabile;
    }

    public void setEditore(String editore) {
        this.editore = editore;
    }

    public void setFontiFinanziamento(List<String> fontiFinanziamento) {
        this.fontiFinanziamento = fontiFinanziamento;
    }

    public void setSoggetto(List<String> soggetto) {
        this.soggetto = soggetto;
    }

    public void setRisorseCorrelate(List<String> risorseCorrelate) {
        this.risorseCorrelate = risorseCorrelate;
    }

    public void setDataInizioProgetto(LocalDateTime dataInizioProgetto) {
        this.dataInizioProgetto = dataInizioProgetto;
    }

    public void setDataFineProgetto(LocalDateTime dataFineProgetto) {
        this.dataFineProgetto = dataFineProgetto;
    }

    public void setTitolareLicenza(String titolareLicenza) {
        this.titolareLicenza = titolareLicenza;
    }

    public void setTitolareCopyright(String titolareCopyright) {
        this.titolareCopyright = titolareCopyright;
    }

    public void setParoleChiaveLibere(List<String> paroleChiaveLibere) {
        this.paroleChiaveLibere = paroleChiaveLibere;
    }

    public void setParoleChiaveICCD(List<String> paroleChiaveICCD) {
        this.paroleChiaveICCD = paroleChiaveICCD;
    }

    public void setCentroidLat(Double centroidLat) {
        this.centroidLat = centroidLat;
    }

    public void setCentroidLong(Double centroidLong) {
        this.centroidLong = centroidLong;
    }

    public void setRelazioneScavo(RelazioneScavo relazioneScavo) {
        this.relazioneScavo = relazioneScavo;
    }

    public void setImmaginiRappresentative(List<UploadedImage> immaginiRappresentative) {
        this.immaginiRappresentative = immaginiRappresentative;
    }

    public void setPosizionamentoScavo(LayerConcessione posizionamentoScavo) {
        this.posizionamentoScavo = posizionamentoScavo;
    }

    public void setPianteFineScavo(List<LayerConcessione> pianteFineScavo) {
        this.pianteFineScavo = pianteFineScavo;
    }

    public void setGenericContent(List<OtherContent> genericContent) {
        this.genericContent = genericContent;
    }

    @Override
    public String toString() {
        return "Concessione(super=" + super.toString() + ", introduzione=" + this.getIntroduzione() + ", descrizioneContenuto=" + this.getDescrizioneContenuto() + ", authors=" + this.getAuthors() + ", contributore=" + this.getContributore() + ", titolari=" + this.getTitolari() + ", responsabile=" + this.getResponsabile() + ", editore=" + this.getEditore() + ", fontiFinanziamento=" + this.getFontiFinanziamento() + ", soggetto=" + this.getSoggetto() + ", risorseCorrelate=" + this.getRisorseCorrelate() + ", dataInizioProgetto=" + this.getDataInizioProgetto() + ", dataFineProgetto=" + this.getDataFineProgetto() + ", titolareLicenza=" + this.getTitolareLicenza() + ", titolareCopyright=" + this.getTitolareCopyright() + ", paroleChiaveLibere=" + this.getParoleChiaveLibere() + ", paroleChiaveICCD=" + this.getParoleChiaveICCD() + ", centroidLat=" + this.getCentroidLat() + ", centroidLong=" + this.getCentroidLong() + ", relazioneScavo=" + this.getRelazioneScavo() + ", immaginiRappresentative=" + this.getImmaginiRappresentative() + ", posizionamentoScavo=" + this.getPosizionamentoScavo() + ", pianteFineScavo=" + this.getPianteFineScavo() + ", genericContent=" + this.getGenericContent() + ")";
    }
}

