/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.storage;

import java.io.File;
import java.net.URL;
import org.gcube.application.geoportal.model.content.GeoServerContent;
import org.gcube.application.geoportal.model.fault.SDIInteractionException;
import org.gcube.data.transfer.library.DataTransferClient;
import org.gcube.data.transfer.library.TransferResult;
import org.gcube.data.transfer.library.faults.DestinationNotSetException;
import org.gcube.data.transfer.library.faults.FailedTransferException;
import org.gcube.data.transfer.library.faults.InitializationException;
import org.gcube.data.transfer.library.faults.InvalidDestinationException;
import org.gcube.data.transfer.library.faults.InvalidSourceException;
import org.gcube.data.transfer.library.faults.SourceNotSetException;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.spatial.data.gis.GISInterface;
import org.gcube.spatial.data.gis.is.AbstractGeoServerDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDIManager {
    private static final Logger log = LoggerFactory.getLogger(SDIManager.class);
    private GISInterface gis;
    private DataTransferClient dtGeoServer;
    private String geoserverHostName;

    public SDIManager() throws SDIInteractionException {
        try {
            log.debug("Initializing GIS Interface..");
            this.gis = GISInterface.get((AbstractGeoServerDescriptor[])new AbstractGeoServerDescriptor[0]);
            AbstractGeoServerDescriptor geoserver = this.gis.getCurrentGeoServer();
            if (geoserver == null) {
                throw new Exception("Unable to contact data transfer for geoserver ");
            }
            log.debug("Found geoserver descriptor " + geoserver);
            this.geoserverHostName = new URL(this.gis.getCurrentGeoServer().getUrl()).getHost();
            log.debug("Contacting Data Transfer from geoserver {} ", (Object)this.geoserverHostName);
            this.dtGeoServer = DataTransferClient.getInstanceByEndpoint((String)("http://" + this.geoserverHostName));
        }
        catch (Exception e) {
            throw new SDIInteractionException("Unable to initialize SDI Manager", e);
        }
    }

    public GeoServerContent pushLayerFile(File theFile, String filename, long projectID, long layerID) throws SDIInteractionException {
        try {
            Destination destination = new Destination(filename);
            destination.setCreateSubfolders(Boolean.valueOf(true));
            destination.setOnExistingFileName(DestinationClashPolicy.REWRITE);
            destination.setPersistenceId("geoserver");
            destination.setSubFolder("GNA/" + projectID + "/" + layerID);
            TransferResult result = this.dtGeoServer.localFile(theFile, destination);
            GeoServerContent content = new GeoServerContent();
            content.setFilename(filename);
            content.setGeoserverPath(result.getRemotePath());
            content.setGeoserverHostName(this.geoserverHostName);
            return content;
        }
        catch (DestinationNotSetException | FailedTransferException | InitializationException | InvalidDestinationException | InvalidSourceException | SourceNotSetException e) {
            throw new SDIInteractionException("Unable to transfer file " + filename, e);
        }
    }
}

