/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.model.db;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import org.gcube.application.geoportal.utils.ISUtils;

public class DatabaseConnection {
    @NonNull
    private String user;
    @NonNull
    private String pwd;
    @NonNull
    private String url;
    private Boolean autocommit = false;

    public static DatabaseConnection get(TYPE type) {
        return ISUtils.queryForDB("postgis", type.toString());
    }

    @NonNull
    public String getUser() {
        return this.user;
    }

    @NonNull
    public String getPwd() {
        return this.pwd;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    public Boolean getAutocommit() {
        return this.autocommit;
    }

    public void setUser(@NonNull String user) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        this.user = user;
    }

    public void setPwd(@NonNull String pwd) {
        if (pwd == null) {
            throw new NullPointerException("pwd");
        }
        this.pwd = pwd;
    }

    public void setUrl(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        this.url = url;
    }

    public void setAutocommit(Boolean autocommit) {
        this.autocommit = autocommit;
    }

    @ConstructorProperties(value={"user", "pwd", "url"})
    public DatabaseConnection(@NonNull String user, @NonNull String pwd, @NonNull String url) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (pwd == null) {
            throw new NullPointerException("pwd");
        }
        if (url == null) {
            throw new NullPointerException("url");
        }
        this.user = user;
        this.pwd = pwd;
        this.url = url;
    }

    public String toString() {
        return "DatabaseConnection(user=" + this.getUser() + ", pwd=" + this.getPwd() + ", url=" + this.getUrl() + ", autocommit=" + this.getAutocommit() + ")";
    }

    public static enum TYPE {
        Concessioni,
        Mosi,
        Mopr;

    }
}

