/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.LocalDateTime;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import org.gcube.application.geoportal.model.AccessPolicy;
import org.gcube.application.geoportal.model.RecordType;
import org.gcube.application.geoportal.model.report.ValidationReport;
import org.gcube.application.geoportal.model.vre.GCubeUser;
import org.gcube.application.geoportal.model.vre.SocialManager;
import org.gcube.application.geoportal.utils.Serialization;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class Record {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @Enumerated(value=EnumType.STRING)
    private RecordType recordType;
    private String version = "1.0.0";
    private String licenzaID;
    @Enumerated(value=EnumType.STRING)
    private AccessPolicy accesso;
    private String nome;
    private String folderId;
    private LocalDateTime lastUpdateTime = LocalDateTime.now();
    private String lastUpdateUser;
    private LocalDateTime creationTime = LocalDateTime.now();
    private String creationUser;

    protected Record() {
        GCubeUser user = SocialManager.getCurrentUser();
        this.setLastUpdateUser(user.getName());
        this.setCreationUser(user.getName());
    }

    public String asJson() throws JsonProcessingException {
        return Serialization.asJSON(this);
    }

    public ValidationReport validate() {
        ValidationReport validator = new ValidationReport("Core metadata");
        validator.checkMandatory((Object)this.getRecordType(), "Record Type");
        validator.checkMandatory(this.getVersion(), "Version");
        validator.checkMandatory((Object)this.getAccesso(), "Accesso ");
        validator.checkMandatory(this.getNome(), "Nome");
        validator.checkMandatory(this.getLastUpdateTime(), "Last Update Time");
        validator.checkMandatory(this.getLastUpdateUser(), "Last Update User");
        validator.checkMandatory(this.getCreationTime(), "Creation Time");
        validator.checkMandatory(this.getCreationUser(), "Creation User");
        validator.checkMandatory(this.getLicenzaID(), "Licenza ID");
        return validator;
    }

    public long getId() {
        return this.id;
    }

    public RecordType getRecordType() {
        return this.recordType;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLicenzaID() {
        return this.licenzaID;
    }

    public AccessPolicy getAccesso() {
        return this.accesso;
    }

    public String getNome() {
        return this.nome;
    }

    public String getFolderId() {
        return this.folderId;
    }

    public LocalDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return this.lastUpdateUser;
    }

    public LocalDateTime getCreationTime() {
        return this.creationTime;
    }

    public String getCreationUser() {
        return this.creationUser;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setRecordType(RecordType recordType) {
        this.recordType = recordType;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setLicenzaID(String licenzaID) {
        this.licenzaID = licenzaID;
    }

    public void setAccesso(AccessPolicy accesso) {
        this.accesso = accesso;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    public void setLastUpdateTime(LocalDateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public void setCreationUser(String creationUser) {
        this.creationUser = creationUser;
    }

    public String toString() {
        return "Record(id=" + this.getId() + ", recordType=" + (Object)((Object)this.getRecordType()) + ", version=" + this.getVersion() + ", licenzaID=" + this.getLicenzaID() + ", accesso=" + (Object)((Object)this.getAccesso()) + ", nome=" + this.getNome() + ", folderId=" + this.getFolderId() + ", lastUpdateTime=" + this.getLastUpdateTime() + ", lastUpdateUser=" + this.getLastUpdateUser() + ", creationTime=" + this.getCreationTime() + ", creationUser=" + this.getCreationUser() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Record)) {
            return false;
        }
        Record other = (Record)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        RecordType this$recordType = this.getRecordType();
        RecordType other$recordType = other.getRecordType();
        if (this$recordType == null ? other$recordType != null : !((Object)((Object)this$recordType)).equals((Object)other$recordType)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$licenzaID = this.getLicenzaID();
        String other$licenzaID = other.getLicenzaID();
        if (this$licenzaID == null ? other$licenzaID != null : !this$licenzaID.equals(other$licenzaID)) {
            return false;
        }
        AccessPolicy this$accesso = this.getAccesso();
        AccessPolicy other$accesso = other.getAccesso();
        if (this$accesso == null ? other$accesso != null : !((Object)((Object)this$accesso)).equals((Object)other$accesso)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$folderId = this.getFolderId();
        String other$folderId = other.getFolderId();
        if (this$folderId == null ? other$folderId != null : !this$folderId.equals(other$folderId)) {
            return false;
        }
        LocalDateTime this$lastUpdateTime = this.getLastUpdateTime();
        LocalDateTime other$lastUpdateTime = other.getLastUpdateTime();
        if (this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime)) {
            return false;
        }
        String this$lastUpdateUser = this.getLastUpdateUser();
        String other$lastUpdateUser = other.getLastUpdateUser();
        if (this$lastUpdateUser == null ? other$lastUpdateUser != null : !this$lastUpdateUser.equals(other$lastUpdateUser)) {
            return false;
        }
        LocalDateTime this$creationTime = this.getCreationTime();
        LocalDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        String this$creationUser = this.getCreationUser();
        String other$creationUser = other.getCreationUser();
        return !(this$creationUser == null ? other$creationUser != null : !this$creationUser.equals(other$creationUser));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Record;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        RecordType $recordType = this.getRecordType();
        result = result * 59 + ($recordType == null ? 0 : ((Object)((Object)$recordType)).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 0 : $version.hashCode());
        String $licenzaID = this.getLicenzaID();
        result = result * 59 + ($licenzaID == null ? 0 : $licenzaID.hashCode());
        AccessPolicy $accesso = this.getAccesso();
        result = result * 59 + ($accesso == null ? 0 : ((Object)((Object)$accesso)).hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 0 : $nome.hashCode());
        String $folderId = this.getFolderId();
        result = result * 59 + ($folderId == null ? 0 : $folderId.hashCode());
        LocalDateTime $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + ($lastUpdateTime == null ? 0 : ((Object)$lastUpdateTime).hashCode());
        String $lastUpdateUser = this.getLastUpdateUser();
        result = result * 59 + ($lastUpdateUser == null ? 0 : $lastUpdateUser.hashCode());
        LocalDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 0 : ((Object)$creationTime).hashCode());
        String $creationUser = this.getCreationUser();
        result = result * 59 + ($creationUser == null ? 0 : $creationUser.hashCode());
        return result;
    }
}

